/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.bounding.BoundingVolume;
import com.jme.intersection.CollisionResults;
import com.jme.intersection.PickResults;
import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.Renderer;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.UserDataManager;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Spatial
extends SceneElement
implements Serializable,
Savable {
    protected Quaternion localRotation = new Quaternion();
    protected Quaternion worldRotation = new Quaternion();
    protected Vector3f localTranslation = new Vector3f();
    protected Vector3f worldTranslation = new Vector3f();
    protected Vector3f localScale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected Vector3f worldScale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected transient Node parent;
    protected ArrayList<Controller> geometricalControllers;
    private static final Vector3f compVecA = new Vector3f();
    private static final Quaternion compQuat = new Quaternion();
    private static final long serialVersionUID = 1L;

    public Spatial() {
    }

    public Spatial(String string) {
        this();
        this.name = string;
    }

    public void addController(Controller controller) {
        if (this.geometricalControllers == null) {
            this.geometricalControllers = new ArrayList(1);
        }
        this.geometricalControllers.add(controller);
    }

    public boolean removeController(Controller controller) {
        if (this.geometricalControllers == null) {
            return false;
        }
        return this.geometricalControllers.remove(controller);
    }

    public Controller removeController(int n) {
        if (this.geometricalControllers == null) {
            return null;
        }
        return this.geometricalControllers.remove(n);
    }

    public void clearControllers() {
        if (this.geometricalControllers != null) {
            this.geometricalControllers.clear();
        }
    }

    public Controller getController(int n) {
        if (this.geometricalControllers == null) {
            this.geometricalControllers = new ArrayList(1);
        }
        return this.geometricalControllers.get(n);
    }

    public ArrayList<Controller> getControllers() {
        if (this.geometricalControllers == null) {
            this.geometricalControllers = new ArrayList(1);
        }
        return this.geometricalControllers;
    }

    public int getControllerCount() {
        if (this.geometricalControllers == null) {
            return 0;
        }
        return this.geometricalControllers.size();
    }

    public void onDraw(Renderer renderer) {
        int n = this.getCullMode();
        if (n == 2) {
            this.setLastFrustumIntersection(0);
            return;
        }
        if (n == 3) {
            this.setLastFrustumIntersection(2);
            this.draw(renderer);
            return;
        }
        Camera camera = renderer.getCamera();
        int n2 = camera.getPlaneState();
        int n3 = this.frustrumIntersects = this.parent != null ? this.parent.frustrumIntersects : 1;
        if (n == 1 && this.frustrumIntersects == 1) {
            this.frustrumIntersects = camera.contains(this.worldBound);
        }
        if (this.frustrumIntersects != 0) {
            this.draw(renderer);
        }
        camera.setPlaneState(n2);
    }

    public Quaternion getWorldRotation() {
        return this.worldRotation;
    }

    public Vector3f getWorldTranslation() {
        return this.worldTranslation;
    }

    public Vector3f getWorldScale() {
        return this.worldScale;
    }

    public void rotateUpTo(Vector3f vector3f) {
        Vector3f vector3f2 = compVecA.set(Vector3f.UNIT_Y);
        this.localRotation.multLocal(vector3f2);
        float f = vector3f2.angleBetween(vector3f);
        Vector3f vector3f3 = vector3f2.crossLocal(vector3f).normalizeLocal();
        Quaternion quaternion = compQuat;
        quaternion.fromAngleNormalAxis(f, vector3f3);
        quaternion.mult(this.localRotation, this.localRotation);
    }

    public void lookAt(Vector3f vector3f, Vector3f vector3f2) {
        compVecA.set(vector3f).subtractLocal(this.getWorldTranslation());
        this.getLocalRotation().lookAt(compVecA, vector3f2);
    }

    @Override
    public void lockTransforms() {
        this.updateWorldVectors();
        this.lockedMode |= 4;
    }

    @Override
    public void updateGeometricState(float f, boolean bl) {
        if ((this.lockedMode & 0x10) != 0) {
            return;
        }
        this.updateWorldData(f);
        if ((this.lockedMode & 1) == 0) {
            this.updateWorldBound();
            if (bl) {
                this.propagateBoundToRoot();
            }
        }
    }

    public void updateWorldData(float f) {
        if (this.geometricalControllers != null) {
            int n = this.geometricalControllers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    Controller controller = this.geometricalControllers.get(i);
                    if (controller == null || !controller.isActive()) continue;
                    controller.update(f);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
        }
        this.updateWorldVectors();
    }

    public void updateWorldVectors() {
        if ((this.lockedMode & 4) == 0) {
            this.updateWorldScale();
            this.updateWorldRotation();
            this.updateWorldTranslation();
        }
    }

    protected void updateWorldTranslation() {
        if (this.parent != null) {
            this.worldTranslation = this.parent.localToWorld(this.localTranslation, this.worldTranslation);
        } else {
            this.worldTranslation.set(this.localTranslation);
        }
    }

    protected void updateWorldRotation() {
        if (this.parent != null) {
            this.parent.getWorldRotation().mult(this.localRotation, this.worldRotation);
        } else {
            this.worldRotation.set(this.localRotation);
        }
    }

    protected void updateWorldScale() {
        if (this.parent != null) {
            this.worldScale.set(this.parent.getWorldScale()).multLocal(this.localScale);
        } else {
            this.worldScale.set(this.localScale);
        }
    }

    public Vector3f localToWorld(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        return this.getWorldRotation().mult(vector3f2.set(vector3f).multLocal(this.getWorldScale()), vector3f2).addLocal(this.getWorldTranslation());
    }

    public Vector3f worldToLocal(Vector3f vector3f, Vector3f vector3f2) {
        vector3f.subtract(this.getWorldTranslation(), vector3f2).divideLocal(this.getWorldScale());
        this.getWorldRotation().inverse().mult(vector3f2, vector3f2);
        return vector3f2;
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node node) {
        this.parent = node;
    }

    public boolean removeFromParent() {
        if (this.parent != null) {
            this.parent.detachChild(this);
            return true;
        }
        return false;
    }

    public Quaternion getLocalRotation() {
        return this.localRotation;
    }

    public void setLocalRotation(Matrix3f matrix3f) {
        if (this.localRotation == null) {
            this.localRotation = new Quaternion();
        }
        this.localRotation.fromRotationMatrix(matrix3f);
        this.worldRotation.set(this.localRotation);
    }

    public void setLocalRotation(Quaternion quaternion) {
        this.localRotation = quaternion;
        this.worldRotation.set(this.localRotation);
    }

    public Vector3f getLocalScale() {
        return this.localScale;
    }

    public void setLocalScale(float f) {
        this.localScale.x = f;
        this.localScale.y = f;
        this.localScale.z = f;
        this.worldScale.set(this.localScale);
    }

    public void setLocalScale(Vector3f vector3f) {
        this.localScale = vector3f;
        this.worldScale.set(this.localScale);
    }

    public Vector3f getLocalTranslation() {
        return this.localTranslation;
    }

    public void setLocalTranslation(Vector3f vector3f) {
        this.localTranslation = vector3f;
        this.worldTranslation.set(this.localTranslation);
    }

    public void setLocalTranslation(float f, float f2, float f3) {
        this.localTranslation.set(f, f2, f3);
        this.worldTranslation.set(this.localTranslation);
    }

    public void setZOrder(int n, boolean bl) {
        block2: {
            block3: {
                this.setZOrder(n);
                if (!bl) break block2;
                if (!(this instanceof Node)) break block3;
                Node node = (Node)this;
                for (Spatial spatial : node.getChildren()) {
                    spatial.setZOrder(n, true);
                }
                break block2;
            }
            if (!(this instanceof Geometry)) break block2;
            Geometry geometry = (Geometry)this;
            int n2 = geometry.getBatchCount();
            while (--n2 >= 0) {
                geometry.getBatch(n2).setZOrder(n);
            }
        }
    }

    @Override
    public int getCullMode() {
        if (this.cullMode != 0) {
            return this.cullMode;
        }
        if (this.parent != null) {
            return this.parent.getCullMode();
        }
        return 1;
    }

    @Override
    public int getTextureCombineMode() {
        if (this.textureCombineMode != 4) {
            return this.textureCombineMode;
        }
        if (this.parent != null) {
            return this.parent.getTextureCombineMode();
        }
        return 2;
    }

    @Override
    public int getLightCombineMode() {
        if (this.lightCombineMode != 4) {
            return this.lightCombineMode;
        }
        if (this.parent != null) {
            return this.parent.getLightCombineMode();
        }
        return 1;
    }

    @Override
    public int getRenderQueueMode() {
        if (this.renderQueueMode != 0) {
            return this.renderQueueMode;
        }
        if (this.parent != null) {
            return this.parent.getRenderQueueMode();
        }
        return 1;
    }

    @Override
    public int getNormalsMode() {
        if (this.normalsMode != 0) {
            return this.normalsMode;
        }
        if (this.parent != null) {
            return this.parent.getNormalsMode();
        }
        return 3;
    }

    @Override
    public void propagateStatesFromRoot(Stack[] stackArray) {
        if (this.parent != null) {
            this.parent.propagateStatesFromRoot(stackArray);
        }
        for (int i = 0; i < 17; ++i) {
            if (this.getRenderState(i) == null) continue;
            stackArray[i].push(this.getRenderState(i));
        }
    }

    @Override
    public void propagateBoundToRoot() {
        if (this.parent != null) {
            this.parent.updateWorldBound();
            this.parent.propagateBoundToRoot();
        }
    }

    public void calculateCollisions(Spatial spatial, CollisionResults collisionResults) {
        this.findCollisions(spatial, collisionResults);
        collisionResults.processCollisions();
    }

    public abstract void updateModelBound();

    public abstract void setModelBound(BoundingVolume var1);

    public abstract void findCollisions(Spatial var1, CollisionResults var2);

    public abstract boolean hasCollision(Spatial var1, boolean var2);

    public void calculatePick(Ray ray, PickResults pickResults) {
        this.findPick(ray, pickResults);
        pickResults.processPick();
    }

    public abstract void findPick(Ray var1, PickResults var2);

    public void setUserData(String string, Savable savable) {
        UserDataManager.getInstance().setUserData(this, string, savable);
    }

    public Savable getUserData(String string) {
        return UserDataManager.getInstance().getUserData(this, string);
    }

    public Savable removeUserData(String string) {
        return UserDataManager.getInstance().removeUserData(this, string);
    }

    public abstract int getVertexCount();

    public abstract int getTriangleCount();

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.localRotation, "localRotation", new Quaternion());
        outputCapsule.write(this.localTranslation, "localTranslation", Vector3f.ZERO);
        outputCapsule.write(this.localScale, "localScale", Vector3f.UNIT_XYZ);
        outputCapsule.writeStringSavableMap(UserDataManager.getInstance().getAllData(this), "userData", null);
        outputCapsule.writeSavableArrayList(this.geometricalControllers, "geometricalControllers", null);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.localRotation = (Quaternion)inputCapsule.readSavable("localRotation", new Quaternion());
        this.localTranslation = (Vector3f)inputCapsule.readSavable("localTranslation", Vector3f.ZERO.clone());
        this.localScale = (Vector3f)inputCapsule.readSavable("localScale", Vector3f.UNIT_XYZ.clone());
        HashMap hashMap = (HashMap)inputCapsule.readStringSavableMap("userData", null);
        if (hashMap != null) {
            UserDataManager.getInstance().setAllData(this, hashMap);
        }
        this.geometricalControllers = inputCapsule.readSavableArrayList("geometricalControllers", null);
        this.worldRotation = new Quaternion();
        this.worldTranslation = new Vector3f();
        this.worldScale = new Vector3f(1.0f, 1.0f, 1.0f);
    }
}

