/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shadow;

import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Plane;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Geometry;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shadow.ShadowEdge;
import com.jme.scene.shadow.ShadowTriangle;
import com.jme.scene.shadow.ShadowVolume;
import com.jme.scene.state.LightState;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshShadows {
    private static final long serialVersionUID = 1L;
    protected float projectionLength = 1000.0f;
    protected ArrayList<ShadowTriangle> faces;
    protected BitSet facing;
    protected TriangleBatch target = null;
    protected ArrayList<ShadowVolume> volumes = new ArrayList();
    protected Quaternion oldWorldRotation = new Quaternion();
    protected Vector3f oldWorldTranslation = new Vector3f();
    protected Vector3f oldWorldScale = new Vector3f();
    private int maxIndex;
    private int vertCount;
    public static long throttle = 20L;
    private long lastTime;
    private boolean nextTime = true;
    protected static Vector3f compVect = new Vector3f();

    public MeshShadows(TriangleBatch triangleBatch) {
        this.target = triangleBatch;
        this.recreateFaces();
    }

    public void createGeometry(LightState lightState) {
        if (this.target.getTriangleCount() != this.maxIndex || this.target.getVertexCount() != this.vertCount) {
            this.recreateFaces();
        }
        FloatBuffer floatBuffer = null;
        if (lightState.getQuantity() != 0) {
            LightState lightState2 = lightState;
            if (this.updateCache(lightState2)) {
                return;
            }
            for (int i = 0; i < lightState2.getQuantity(); ++i) {
                IntBuffer intBuffer;
                FloatBuffer floatBuffer2;
                Light light = lightState2.get(i);
                if (!light.isShadowCaster() || light.getType() != 0 && light.getType() != 1) continue;
                ShadowVolume shadowVolume = this.getShadowVolume(light);
                if (shadowVolume == null) {
                    shadowVolume = new ShadowVolume(light);
                    if (shadowVolume.getBatchCount() < 1) {
                        shadowVolume.addBatch(new TriangleBatch());
                    }
                    this.volumes.add(shadowVolume);
                    shadowVolume.setUpdate(true);
                }
                if (!shadowVolume.isUpdate()) continue;
                shadowVolume.setUpdate(false);
                if (!this.target.isEnabled() || !this.target.isCastsShadows()) {
                    shadowVolume.getBatch(0).setEnabled(false);
                    continue;
                }
                shadowVolume.getBatch(0).setEnabled(true);
                if (floatBuffer == null) {
                    floatBuffer = this.target.getWorldCoords(null);
                }
                this.processFaces(floatBuffer, light, this.target);
                ShadowEdge[] shadowEdgeArray = this.getShadowEdges();
                int n = shadowEdgeArray.length;
                FloatBuffer floatBuffer3 = shadowVolume.getBatch(0).getVertexBuffer();
                if (floatBuffer3 == null || floatBuffer3.capacity() < n * 12) {
                    floatBuffer3 = BufferUtils.createVector3Buffer(n * 4);
                }
                if ((floatBuffer2 = shadowVolume.getBatch(0).getNormalBuffer()) == null || floatBuffer2.capacity() < n * 12) {
                    floatBuffer2 = BufferUtils.createVector3Buffer(n * 4);
                }
                if ((intBuffer = shadowVolume.getBatch(0).getIndexBuffer()) == null || intBuffer.capacity() < n * 6) {
                    intBuffer = BufferUtils.createIntBuffer(n * 6);
                }
                floatBuffer3.limit(n * 12);
                floatBuffer2.limit(n * 12);
                intBuffer.limit(n * 6);
                this.createShadowQuads(floatBuffer, shadowEdgeArray, floatBuffer3, floatBuffer2, intBuffer, light);
                shadowVolume.reconstruct(floatBuffer3, floatBuffer2, null, null, intBuffer, 0);
                floatBuffer3.rewind();
                shadowVolume.getBatch(0).setVertexCount(floatBuffer3.remaining() / 3);
                intBuffer.rewind();
                shadowVolume.getBatch(0).setTriangleQuantity(intBuffer.remaining() / 3);
                shadowVolume.updateModelBound();
                if ((this.target.getLocks() & 8) == 0) continue;
                shadowVolume.lock();
            }
        } else {
            this.volumes.clear();
        }
    }

    private void createShadowQuads(FloatBuffer floatBuffer, ShadowEdge[] shadowEdgeArray, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, IntBuffer intBuffer, Light light) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        boolean bl = light.getType() == 0;
        Vector3f vector3f5 = new Vector3f();
        Vector3f vector3f6 = new Vector3f();
        if (bl) {
            vector3f5 = ((DirectionalLight)light).getDirection();
        } else {
            vector3f6 = ((PointLight)light).getLocation();
        }
        for (int i = 0; i < shadowEdgeArray.length; ++i) {
            BufferUtils.populateFromBuffer(vector3f, floatBuffer, shadowEdgeArray[i].p0);
            BufferUtils.populateFromBuffer(vector3f4, floatBuffer, shadowEdgeArray[i].p1);
            if (!bl) {
                vector3f5 = vector3f.subtract(vector3f6, vector3f5).normalizeLocal();
            }
            vector3f2 = vector3f5.mult(this.projectionLength, vector3f2).addLocal(vector3f);
            if (!bl) {
                vector3f5 = vector3f4.subtract(vector3f6, vector3f5).normalizeLocal();
            }
            vector3f3 = vector3f5.mult(this.projectionLength).addLocal(vector3f4);
            int n = i * 4;
            BufferUtils.setInBuffer(vector3f, floatBuffer2, n);
            BufferUtils.setInBuffer(vector3f2, floatBuffer2, n + 1);
            BufferUtils.setInBuffer(vector3f3, floatBuffer2, n + 2);
            BufferUtils.setInBuffer(vector3f4, floatBuffer2, n + 3);
            Vector3f vector3f7 = vector3f2.subtract(vector3f).normalizeLocal().crossLocal(vector3f4.subtract(vector3f).normalizeLocal()).normalizeLocal();
            BufferUtils.setInBuffer(vector3f7, floatBuffer3, n);
            BufferUtils.setInBuffer(vector3f7, floatBuffer3, n + 1);
            BufferUtils.setInBuffer(vector3f7, floatBuffer3, n + 2);
            BufferUtils.setInBuffer(vector3f7, floatBuffer3, n + 3);
            int n2 = i * 6;
            intBuffer.put(n2 + 0, n + 0);
            intBuffer.put(n2 + 1, n + 1);
            intBuffer.put(n2 + 2, n + 3);
            intBuffer.put(n2 + 3, n + 3);
            intBuffer.put(n2 + 4, n + 1);
            intBuffer.put(n2 + 5, n + 2);
        }
    }

    protected float getIntersectTime(Plane plane, Vector3f vector3f, Vector3f vector3f2) {
        float f = plane.normal.dot(vector3f2);
        if (f == 0.0f) {
            return -3.4028235E38f;
        }
        return plane.normal.dot(plane.normal.mult(plane.constant, compVect).subtractLocal(vector3f)) / f;
    }

    private ShadowEdge[] getShadowEdges() {
        ArrayList<ShadowEdge> arrayList = new ArrayList<ShadowEdge>();
        for (int i = 0; i < this.maxIndex; ++i) {
            if (!this.facing.get(i)) continue;
            ShadowTriangle shadowTriangle = this.faces.get(i);
            this.checkAndAdd(shadowTriangle.edge1, arrayList);
            this.checkAndAdd(shadowTriangle.edge2, arrayList);
            this.checkAndAdd(shadowTriangle.edge3, arrayList);
        }
        return arrayList.toArray(new ShadowEdge[0]);
    }

    private void checkAndAdd(ShadowEdge shadowEdge, ArrayList<ShadowEdge> arrayList) {
        if (shadowEdge.triangle == -1) {
            arrayList.add(shadowEdge);
        } else if (!this.facing.get(shadowEdge.triangle)) {
            arrayList.add(shadowEdge);
        }
    }

    private void processFaces(FloatBuffer floatBuffer, Light light, TriangleBatch triangleBatch) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        boolean bl = light.getType() == 0;
        Vector3f vector3f3 = null;
        int[] nArray = BufferUtils.getIntArray(triangleBatch.getIndexBuffer());
        if (bl) {
            vector3f3 = ((DirectionalLight)light).getDirection();
        }
        int n = 0;
        for (int i = 0; i < nArray.length; i += 3) {
            BufferUtils.populateFromBuffer(compVect, floatBuffer, nArray[i]);
            BufferUtils.populateFromBuffer(vector3f, floatBuffer, nArray[i + 1]);
            BufferUtils.populateFromBuffer(vector3f2, floatBuffer, nArray[i + 2]);
            vector3f2.subtractLocal(vector3f).normalizeLocal();
            vector3f.subtractLocal(compVect).normalizeLocal();
            Vector3f vector3f4 = vector3f2.cross(vector3f);
            if (!bl) {
                vector3f3 = compVect.subtract(((PointLight)light).getLocation()).normalizeLocal();
            }
            this.facing.set(n, vector3f4.dot(vector3f3) >= 0.0f);
            ++n;
        }
    }

    private boolean updateCache(LightState lightState) {
        boolean bl = false;
        boolean bl2 = true;
        float f = System.currentTimeMillis() - this.lastTime;
        Geometry geometry = this.target.getParentGeom();
        if (this.nextTime) {
            if (f > (float)throttle) {
                bl = true;
                this.nextTime = false;
            }
        } else if (!geometry.getWorldRotation().equals(this.oldWorldRotation)) {
            bl = true;
        } else if (!geometry.getWorldScale().equals(this.oldWorldScale)) {
            bl = true;
        } else if (!geometry.getWorldTranslation().equals(this.oldWorldTranslation)) {
            bl = true;
        }
        this.oldWorldRotation.set(geometry.getWorldRotation());
        this.oldWorldScale.set(geometry.getWorldScale());
        this.oldWorldTranslation.set(geometry.getWorldTranslation());
        if (this.target.hasDirtyVertices()) {
            this.target.setHasDirtyVertices(false);
            if (!bl) {
                if (f > (float)throttle) {
                    bl = true;
                    this.nextTime = false;
                } else {
                    this.nextTime = true;
                }
            }
        }
        if (bl) {
            int n = this.volumes.size();
            for (int i = 0; i < n; ++i) {
                ShadowVolume shadowVolume = this.volumes.get(i);
                shadowVolume.setUpdate(true);
            }
            this.lastTime = System.currentTimeMillis();
            this.nextTime = false;
            return false;
        }
        int n = lightState.getQuantity();
        while (--n >= 0) {
            Light light = lightState.get(n);
            if (!light.isShadowCaster()) continue;
            ShadowVolume shadowVolume = this.getShadowVolume(light);
            if (shadowVolume != null) {
                Light light2;
                if (light.getType() == 0) {
                    light2 = (DirectionalLight)light;
                    if (shadowVolume.direction.equals(((DirectionalLight)light2).getDirection())) continue;
                    shadowVolume.setUpdate(true);
                    shadowVolume.getDirection().set(((DirectionalLight)light2).getDirection());
                    bl2 = false;
                    continue;
                }
                if (light.getType() != 1) continue;
                light2 = (PointLight)light;
                if (shadowVolume.getPosition().equals(((PointLight)light2).getLocation())) continue;
                shadowVolume.setUpdate(true);
                shadowVolume.getPosition().set(((PointLight)light2).getLocation());
                bl2 = false;
                continue;
            }
            return false;
        }
        return bl2;
    }

    private void edgeConnected(int n, IntBuffer intBuffer, int n2, int n3, ShadowEdge shadowEdge) {
        shadowEdge.p0 = n2;
        shadowEdge.p1 = n3;
        intBuffer.rewind();
        for (int i = 0; i < this.maxIndex; ++i) {
            if (i == n) continue;
            int n4 = i * 3;
            int n5 = intBuffer.get(n4);
            int n6 = intBuffer.get(n4 + 1);
            int n7 = intBuffer.get(n4 + 2);
            if (!(n5 == n2 && n6 == n3 || n6 == n2 && n7 == n3 || n7 == n2 && n5 == n3 || n5 == n3 && n6 == n2 || n6 == n3 && n7 == n2) && (n7 != n3 || n5 != n2)) continue;
            shadowEdge.triangle = i;
            return;
        }
    }

    public void recreateFaces() {
        this.maxIndex = 0;
        this.facing = new BitSet();
        IntBuffer intBuffer = BufferUtils.clone(this.target.getIndexBuffer());
        intBuffer.clear();
        this.faces = new ArrayList();
        this.maxIndex = intBuffer.capacity() / 3;
        this.vertCount = this.target.getVertexCount();
        this.facing = new BitSet(this.maxIndex);
        for (int i = 0; i < this.maxIndex; ++i) {
            ShadowTriangle shadowTriangle = new ShadowTriangle();
            this.faces.add(shadowTriangle);
            int n = i * 3;
            int n2 = intBuffer.get(n);
            int n3 = intBuffer.get(n + 1);
            int n4 = intBuffer.get(n + 2);
            this.edgeConnected(i, intBuffer, n2, n3, shadowTriangle.edge1);
            this.edgeConnected(i, intBuffer, n3, n4, shadowTriangle.edge2);
            this.edgeConnected(i, intBuffer, n4, n2, shadowTriangle.edge3);
        }
    }

    public ShadowVolume getShadowVolume(Light light) {
        int n = this.volumes.size();
        for (int i = 0; i < n; ++i) {
            ShadowVolume shadowVolume = this.volumes.get(i);
            if (!shadowVolume.light.equals(light)) continue;
            return shadowVolume;
        }
        return null;
    }

    public float getProjectionLength() {
        return this.projectionLength;
    }

    public void setProjectionLength(float f) {
        this.projectionLength = f;
        int n = this.volumes.size();
        for (int i = 0; i < n; ++i) {
            this.volumes.get(i).setUpdate(true);
        }
    }

    public ArrayList<ShadowVolume> getVolumes() {
        return this.volumes;
    }
}

