/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JLabel;
import jp.sourceforge.mmosf.server.object.ChatMessage;

public class JMessageLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    protected LinkedList<ChatMessage> messageList = new LinkedList();

    public JMessageLabel() {
        this.redrawMessage();
    }

    public JMessageLabel(String arg0) {
        super(arg0);
        this.redrawMessage();
    }

    public JMessageLabel(Icon arg0) {
        super(arg0);
        this.redrawMessage();
    }

    public JMessageLabel(String arg0, int arg1) {
        super(arg0, arg1);
        this.redrawMessage();
    }

    public JMessageLabel(Icon arg0, int arg1) {
        super(arg0, arg1);
        this.redrawMessage();
    }

    public JMessageLabel(String arg0, Icon arg1, int arg2) {
        super(arg0, arg1, arg2);
        this.redrawMessage();
    }

    protected int redrawMessage() {
        Dimension dimBefore = this.getSize();
        Dimension dimBefore2 = this.getPreferredSize();
        StringBuffer sb = new StringBuffer();
        sb.append("<html><div style=\"width:" + dimBefore.width + "px;\">");
        int i = 0;
        while (i < this.messageList.size()) {
            String color;
            if (i > 0) {
                sb.append("<br>");
            }
            ChatMessage chat = this.messageList.get(i);
            switch (chat.type) {
                case 1: {
                    color = "black";
                    break;
                }
                case 0: {
                    color = "blue";
                    break;
                }
                default: {
                    color = "gray";
                }
            }
            sb.append("<font style=\"color:" + color + "\">");
            if (chat.type == 1) {
                sb.append("(say)");
                sb.append(chat.speaker);
                sb.append(":");
            }
            sb.append(this.messageList.get((int)i).message);
            sb.append("</font>");
            ++i;
        }
        sb.append("</div></html>");
        this.setText(sb.toString());
        Dimension dimAfter2 = this.getPreferredSize();
        return dimAfter2.height - dimBefore2.height;
    }

    public int addMessage(ChatMessage message) {
        this.messageList.add(message);
        return this.redrawMessage();
    }
}

