/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.converters.ObjToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelObject {
    protected static final Log log = LogFactory.getLog(ModelObject.class);
    protected static HashMap<String, TriMesh> map;
    protected TriMesh mesh;
    protected Node nodeRotation;
    protected Node nodeTranslation;
    protected int size;
    protected float scale;
    protected int visual;

    protected ModelObject() {
    }

    protected static Map<String, TriMesh> getModelMap() {
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    protected static TriMesh loadObject(URL objFile) {
        TriMesh model = null;
        ObjToJme converter = new ObjToJme();
        try {
            converter.setProperty("mtllib", (Object)objFile);
            converter.setProperty("texdir", (Object)objFile);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            converter.convert(objFile.openStream(), (OutputStream)os);
            model = (TriMesh)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(os.toByteArray()));
        }
        catch (Exception e) {
            log.error("error in load obj, ", e);
        }
        return model;
    }

    protected static TriMesh getMobMesh(URL objPath, Quaternion defaultRotation, String name, float fsize) {
        TriMesh mesh = ModelObject.getModelMap().get(objPath.toString());
        if (mesh == null) {
            mesh = ModelObject.loadObject(objPath);
            ModelObject.getModelMap().put(objPath.toString(), mesh);
        }
        SharedMesh model = new SharedMesh(String.valueOf(name) + ".mesh", mesh);
        model.setModelBound((BoundingVolume)new BoundingBox());
        model.updateModelBound();
        model.setLocalScale(fsize);
        model.setLocalRotation(defaultRotation);
        return model;
    }

    public static ModelObject getModelObject(URL objPath, Quaternion defaultRotation, String name, float scale, int visual) {
        ModelObject obj = new ModelObject();
        obj.mesh = ModelObject.getMobMesh(objPath, defaultRotation, name, scale);
        obj.nodeRotation = new Node();
        obj.nodeRotation.attachChild((Spatial)obj.mesh);
        obj.nodeTranslation = new Node(name);
        obj.nodeTranslation.attachChild((Spatial)obj.nodeRotation);
        obj.scale = scale;
        obj.size = 1;
        obj.visual = visual;
        return obj;
    }

    public Spatial getObject() {
        return this.nodeTranslation;
    }

    public Node getNodeRotation() {
        return this.nodeRotation;
    }

    public Node getNodeTranslation() {
        return this.nodeTranslation;
    }

    public TriMesh getMesh() {
        return this.mesh;
    }

    public void setDirection(Mob mob) {
        Vector direction = mob.moving.getDirection();
        this.setDirection(direction);
    }

    public void setDirection(Vector direction) {
        Quaternion q = new Quaternion();
        Vector3f v = new Vector3f();
        float value = 0.0f;
        if (!direction.equals(Vector.EAST)) {
            if (direction.equals(Vector.WEST)) {
                value = (float)Math.PI;
                v.x = (float)this.size * this.scale;
                v.z = (float)this.size * this.scale;
            } else if (direction.equals(Vector.SOUTH)) {
                value = -1.5707964f;
                v.x = (float)this.size * this.scale;
            } else if (direction.equals(Vector.NORTH)) {
                value = 1.5707964f;
                v.z = (float)this.size * this.scale;
            } else if (direction.equals(Vector.NORTH_EAST)) {
                value = 0.7853982f;
                v.z = (float)this.size * this.scale * 0.5f;
                v.x = (float)(-this.size) * this.scale * 0.2f;
            } else if (direction.equals(Vector.NORTH_WEST)) {
                value = 2.3561945f;
                v.x = (float)this.size * this.scale * 0.5f;
                v.z = (float)this.size * this.scale * 1.2f;
            } else if (direction.equals(Vector.SOUTH_EAST)) {
                value = -0.7853982f;
                v.x = (float)this.size * this.scale * 0.5f;
                v.z = (float)(-this.size) * this.scale * 0.2f;
            } else if (direction.equals(Vector.SOUTH_WEST)) {
                value = -2.3561945f;
                v.z = (float)this.size * this.scale * 0.5f;
                v.x = (float)this.size * this.scale * 1.2f;
            }
        }
        q.fromAngles(0.0f, value, 0.0f);
        this.nodeRotation.setLocalRotation(q);
        this.nodeRotation.setLocalTranslation(v);
    }

    public void setTranslation(Vector3f v) {
        this.nodeTranslation.setLocalTranslation(v);
    }

    public int getVisual() {
        return this.visual;
    }

    public void clear() {
        this.nodeTranslation.detachAllChildren();
        this.nodeRotation.detachAllChildren();
        this.mesh.clearControllers();
        this.mesh.clearBuffers();
        this.mesh.clearBatches();
        this.mesh = null;
        this.nodeRotation.clearControllers();
        this.nodeRotation = null;
        this.nodeTranslation.clearControllers();
        this.nodeTranslation = null;
    }
}

