/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample.jme;

import java.util.Iterator;
import java.util.LinkedList;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestInfo {
    private String name;
    private int questId;
    private LinkedList<String> listPhaseMessage = new LinkedList();
    private boolean isValid = false;

    public String getName() {
        return this.name;
    }

    public int getQuestId() {
        return this.questId;
    }

    public Iterator<String> getPhaseMssage() {
        return this.listPhaseMessage.iterator();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setQuestPacket(Packet packet) throws PacketFormatException {
        this.questId = packet.getInt("questId");
        this.name = packet.getString("name");
        if (packet.getInt("progress") == 2) {
            this.listPhaseMessage.clear();
            String postMsg = packet.getString("postmsg");
            this.listPhaseMessage.addLast(postMsg);
        } else {
            if (packet.getInt("progress") != 0) {
                this.listPhaseMessage.removeLast();
                String postMsg = packet.getString("postmsg");
                this.listPhaseMessage.addLast(postMsg);
            }
            String preMsg = packet.getString("premsg");
            this.listPhaseMessage.addLast(preMsg);
        }
        this.isValid = true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QuestInfo) {
            QuestInfo info = (QuestInfo)obj;
            return this.questId == info.questId;
        }
        return false;
    }

    public int hashCode() {
        return this.questId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("<br>");
        Iterator<String> it = this.getPhaseMssage();
        while (it.hasNext()) {
            String message = it.next();
            sb.append("\u30fb");
            sb.append(message);
            sb.append("<br>");
        }
        return sb.toString();
    }
}

