/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import jp.sourceforge.mmosf.admin.InputMonitor;
import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.level.ItemFactory;
import jp.sourceforge.mmosf.server.level.LevelManager;
import jp.sourceforge.mmosf.server.level.QuestFactory;
import jp.sourceforge.mmosf.server.object.ChatMessage;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.PlayerCharactor;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.Visual;
import jp.sourceforge.mmosf.server.object.action.ActionCondition;
import jp.sourceforge.mmosf.server.object.action.ActionConditionItem;
import jp.sourceforge.mmosf.server.object.action.ActionConditionQuest;
import jp.sourceforge.mmosf.server.object.action.ActionElement;
import jp.sourceforge.mmosf.server.object.action.ActionResult;
import jp.sourceforge.mmosf.server.object.action.ActionResultChangeStatus;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetItem;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetMenu;
import jp.sourceforge.mmosf.server.object.action.ActionResultGetMessage;
import jp.sourceforge.mmosf.server.object.action.ActionResultPopMob;
import jp.sourceforge.mmosf.server.object.action.ActionResultTriggerQuest;
import jp.sourceforge.mmosf.server.object.dynamicaction.DynamicActionDepopMob;
import jp.sourceforge.mmosf.server.object.dynamicaction.DynamicActionElement;
import jp.sourceforge.mmosf.server.object.dynamicaction.DynamicActionStatusChange;
import jp.sourceforge.mmosf.server.object.item.Item;
import jp.sourceforge.mmosf.server.object.quest.Quest;
import jp.sourceforge.mmosf.server.object.quest.QuestPhase;
import jp.sourceforge.mmosf.server.object.quest.reward.QuestReward;
import jp.sourceforge.mmosf.server.object.quest.reward.QuestRewardGetItem;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameter;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameterAction;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameterActionToItem;
import jp.sourceforge.mmosf.server.object.quest.trigger.TriggerParameterActionToMob;
import jp.sourceforge.mmosf.server.packet.MovePacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.sync.SyncArea;
import jp.sourceforge.mmosf.server.sync.SyncShard;
import jp.sourceforge.mmosf.server.timer.TimerFactory;
import jp.sourceforge.mmosf.server.timer.TimerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingServer
implements TimerListener,
Perception {
    public static final int AI_INTERVAL = 600;
    public static final Log log = LogFactory.getLog(MatchingServer.class);
    protected SyncShard shard = null;
    protected LevelManager level = null;
    protected List<PlayerCharactor> listPC = new LinkedList<PlayerCharactor>();
    protected List<Mob> listNPC;
    protected Timer timer = null;

    public MatchingServer() {
        this.shard = new SyncShard();
        this.level = new LevelManager();
        this.listNPC = this.level.getMob(0);
        for (Mob mob : this.listNPC) {
            SyncArea area = this.shard.getSyncArea(mob.moving.getPosition());
            area.in(mob);
        }
    }

    public void put(Packet packet, PlayerCharactor pc) throws PacketFormatException {
        InputMonitor.getMonitor().log(new String(packet.toBytes().array()));
        try {
            switch (packet.getType()) {
                case 7: {
                    this.processMove(packet, pc);
                    break;
                }
                case 8: {
                    this.processMenu(packet, pc);
                    break;
                }
                case 10: {
                    this.processAction(packet, pc);
                    break;
                }
                case 12: {
                    this.processLog(packet, pc);
                }
            }
        }
        catch (Throwable e) {
            log.error("error in process packet, ", e);
        }
        this.syncArea(pc, packet);
    }

    protected void processLog(Packet packet, PlayerCharactor pc) throws PacketFormatException {
        String string = packet.getString("message");
        String[] logString = string.split(";");
        int i = 0;
        while (i < logString.length) {
            if (logString[i] != null && logString[i].length() != 0) {
                log.debug("time:" + pc.getId() + "/" + logString[i]);
            }
            ++i;
        }
    }

    protected void processAction(Packet packet, PlayerCharactor pc) throws PacketFormatException, IOException {
        ActionElement elm;
        String targetName;
        int id;
        TriggerParameterAction param = null;
        if (packet.getInt("type") == 0) {
            id = packet.getInt("targetid");
            SyncArea area = this.shard.getSyncArea(pc.moving.getPosition());
            Mob target = this.findMobAround(area, id);
            if (target == null) {
                return;
            }
            targetName = String.valueOf(target.c);
            double length = MatchingServer.getDistance(pc.moving.getPosition(), target.moving.getPosition());
            elm = target.act.getAction(packet.getInt("commandid"));
            if ((double)elm.distance < length) {
                Packet sendPacket = PacketFactory.createMessagePacket(new ChatMessage(0, 1));
                pc.conn.send(sendPacket);
                return;
            }
            param = new TriggerParameterActionToMob(target, elm);
        } else {
            id = packet.getInt("slotid");
            Item item = pc.getItem(id);
            if (item == null) {
                return;
            }
            targetName = item.name;
            elm = item.act.getAction(packet.getInt("commandid"));
            param = new TriggerParameterActionToItem(item, elm);
        }
        if (!this.isEnableElement(pc, elm)) {
            return;
        }
        for (ActionResult result : elm.listResult) {
            Packet sendPacket;
            ActionResult result2;
            if (result instanceof ActionResultGetItem) {
                result2 = (ActionResultGetItem)result;
                int slot = pc.addItem(((ActionResultGetItem)result2).item);
                sendPacket = slot == -1 ? PacketFactory.createMessagePacket(new ChatMessage(0, 0)) : PacketFactory.createGetItemStatusPacket(slot, ((ActionResultGetItem)result2).item);
                pc.conn.send(sendPacket);
                continue;
            }
            if (result instanceof ActionResultPopMob) {
                result2 = (ActionResultPopMob)result;
                Mob mob = ((ActionResultPopMob)result2).popMob(pc, this.level.createId());
                SyncArea area2 = this.shard.getSyncArea(mob.moving.getPosition());
                area2.in(mob);
                this.listNPC.add(mob);
                continue;
            }
            if (result instanceof ActionResultGetMenu) {
                result2 = (ActionResultGetMenu)result;
                List<ActionElement> listAction = this.getEnableAction(pc, ((ActionResultGetMenu)result2).act.listAction);
                sendPacket = PacketFactory.createMenuResponsePaket(targetName, ((ActionResultGetMenu)result2).message, listAction);
                pc.conn.send(sendPacket);
                continue;
            }
            if (result instanceof ActionResultGetMessage) {
                result2 = (ActionResultGetMessage)result;
                Packet sendPacket2 = PacketFactory.createMessagePacket(((ActionResultGetMessage)result2).message);
                pc.conn.send(sendPacket2);
                continue;
            }
            if (result instanceof ActionResultTriggerQuest) {
                result2 = (ActionResultTriggerQuest)result;
                int index = pc.getQuestIndex(((ActionResultTriggerQuest)result2).id);
                if (index != -1) continue;
                Quest quest = QuestFactory.createQuest(((ActionResultTriggerQuest)result2).id);
                pc.addQuest(quest);
                Packet sendPacket3 = PacketFactory.createQuestPacket(quest);
                pc.conn.send(sendPacket3);
                continue;
            }
            if (!(result instanceof ActionResultChangeStatus) || !(result2 = (ActionResultChangeStatus)result).isTarget(0) || !(param instanceof TriggerParameterActionToMob)) continue;
            TriggerParameterActionToMob target = (TriggerParameterActionToMob)param;
            if (((ActionResultChangeStatus)result2).status == 1) {
                target.targetMob.moving.setColType(((ActionResultChangeStatus)result2).value);
            } else {
                if (((ActionResultChangeStatus)result2).status != 0) continue;
                target.targetMob.vis = new Visual(((ActionResultChangeStatus)result2).value);
            }
            target.targetMob.dAct.setAndStart(((ActionResultChangeStatus)result2).dAct);
        }
        this.checkQuestTriger(pc, param);
    }

    protected void processMenu(Packet packet, PlayerCharactor pc) throws PacketFormatException, IOException {
        int type = packet.getInt("type");
        switch (type) {
            case 0: {
                int id = packet.getInt("id");
                SyncArea area = this.shard.getSyncArea(pc.moving.getPosition());
                Mob target = this.findMobAround(area, id);
                if (target == null) break;
                List<ActionElement> listAction = this.getEnableAction(pc, target.act.listAction);
                Packet sendPacket = PacketFactory.createMenuResponsePaket(new String(new char[]{target.c}), null, listAction);
                pc.conn.send(sendPacket);
                break;
            }
            case 1: {
                int slot = packet.getInt("slot");
                Item item = pc.getItem(slot);
                if (item == null) break;
                Packet sendPacket = PacketFactory.createMenuResponsePaket(item.name, null, item.act.listAction);
                pc.conn.send(sendPacket);
            }
        }
    }

    protected void processMove(Packet packet, PlayerCharactor pc) throws PacketFormatException, IOException {
        this.move(pc, true);
        Vector v = ((MovePacket)packet).getVector();
        pc.moving.setDirection(v.getDirection());
        MoveObject mo = new MoveObject(pc.moving.getPosition(), v.getBaseVector(), pc.getId());
        if (!this.isEnableMove(mo)) {
            pc.setVector(Vector.ZERO);
            MovingVector mv = new MovingVector(pc.moving.getPosition());
            mv.setVector(Vector.ZERO);
            mv.setDirection(pc.moving.getDirection());
            mv.setSpeed(pc.moving.getSpeed());
            Packet sendPacket = PacketFactory.createMoveResponsePacket(mv);
            pc.conn.send(sendPacket);
            return;
        }
        pc.setVector(v);
        Packet response = PacketFactory.createMoveResponsePacket(pc.moving);
        pc.conn.send(response);
    }

    protected List<ActionElement> getEnableAction(PlayerCharactor pc, List<ActionElement> listAction2) {
        LinkedList<ActionElement> listAction = new LinkedList<ActionElement>();
        listAction.addAll(listAction2);
        Iterator it2 = listAction.iterator();
        while (it2.hasNext()) {
            ActionElement actionElement = (ActionElement)it2.next();
            if (this.isEnableElement(pc, actionElement)) continue;
            it2.remove();
        }
        return listAction;
    }

    protected boolean isEnableElement(PlayerCharactor pc, ActionElement elm) {
        boolean isEnable = true;
        for (ActionCondition actionCondition : elm.listCondition) {
            ActionCondition condition;
            if (actionCondition instanceof ActionConditionQuest) {
                condition = (ActionConditionQuest)actionCondition;
                if (((ActionConditionQuest)condition).isEnable(pc)) continue;
                isEnable = false;
                continue;
            }
            if (!(actionCondition instanceof ActionConditionItem) || ((ActionConditionItem)(condition = (ActionConditionItem)actionCondition)).isEnable(pc)) continue;
            isEnable = false;
        }
        return isEnable;
    }

    public static double getDistance(Position pos1, Position pos2) {
        int x = pos1.getX() - pos2.getX();
        int y = pos1.getY() - pos2.getY();
        double length = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        return length;
    }

    protected Mob findMobAround(SyncArea area, int id) {
        Mob target = area.getMob(id);
        if (target != null) {
            return target;
        }
        List<SyncArea> listArea = area.getSyncAreaAround();
        for (SyncArea a : listArea) {
            Mob m = a.getMob(id);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private void syncArea(PlayerCharactor pc, Packet packet) throws PacketFormatException {
        SyncArea ga = this.shard.getSyncArea(pc.moving.getPosition());
        if (packet.getType() == 2) {
            try {
                Packet sendPacket = PacketFactory.createMessagePacket(ChatMessage.createSay(String.valueOf(pc.c), packet.toString()));
                ga.sendPacket(sendPacket);
                List<SyncArea> listArea = this.shard.getSyncArea(pc.moving.getPosition()).getSyncAreaAround();
                Iterator<SyncArea> it = listArea.iterator();
                while (it.hasNext()) {
                    it.next().sendPacket(sendPacket);
                }
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    public boolean register(PlayerCharactor pc) {
        if (this.listPC.isEmpty()) {
            this.timer = TimerFactory.startTimer(this, 600L);
        }
        this.listPC.add(pc);
        this.shard.getSyncArea(pc.moving.getPosition()).in(pc);
        log.debug("pc+1:total/" + this.listPC.size());
        return true;
    }

    public boolean unregister(PlayerCharactor pc) {
        int index = this.listPC.indexOf(pc);
        this.listPC.remove(index);
        this.shard.getSyncArea(pc.moving.getPosition()).out(pc);
        if (this.listPC.isEmpty()) {
            TimerFactory.stopTimer(this.timer);
        }
        log.debug("pc-1:total/" + this.listPC.size());
        return true;
    }

    @Override
    public void onTimer() {
        log.debug("OnTimer in");
        for (PlayerCharactor pc : this.listPC) {
            this.move(pc, false);
            log.trace("move pc:" + pc.c);
        }
        Iterator<Mob> itMob = this.listNPC.iterator();
        while (itMob.hasNext()) {
            Mob mob = itMob.next();
            this.processDynamicAction(itMob, mob);
            if (mob.moving.isMoveType(0)) continue;
            this.move(mob, false);
            log.trace("move mob:" + mob.c);
        }
        log.debug("OnTimer out");
    }

    protected Vector getMoveQueue(PlayerCharactor pc) {
        Vector vec = pc.getMoveQueue();
        if (vec != null) {
            while (vec.isZero()) {
                Vector vec2 = pc.getMoveQueue();
                if (vec2 == null) break;
                vec = vec2;
            }
        }
        return vec;
    }

    protected void processDynamicAction(Iterator<Mob> itMob, Mob mob) {
        Iterator it = mob.dAct.listElement.iterator();
        while (it.hasNext()) {
            DynamicActionElement elm = (DynamicActionElement)it.next();
            if (!elm.isTimeout()) continue;
            if (elm instanceof DynamicActionDepopMob) {
                log.info("depop event," + mob.getId());
                this.shard.getSyncArea(mob.moving.getPosition()).out(mob);
                itMob.remove();
            } else if (elm instanceof DynamicActionStatusChange) {
                DynamicActionStatusChange elm2 = (DynamicActionStatusChange)elm;
                switch (elm2.status) {
                    case 0: {
                        mob.vis = new Visual(elm2.value);
                        break;
                    }
                    case 1: {
                        mob.moving.setColType(elm2.value);
                    }
                }
            }
            it.remove();
        }
    }

    public void move(Mob mob, boolean isReceive) {
        Position oldPos = mob.moving.getPosition();
        if (isReceive) {
            mob.moving.updateTime(System.currentTimeMillis() - 200L);
        } else {
            mob.moving.updateTime(System.currentTimeMillis());
        }
        mob.moving.move(this);
        if (mob.moving.getPosition().equals(oldPos)) {
            return;
        }
        this.shard.getSyncZone(mob.moving.getPosition()).move(mob, oldPos, mob.moving.getPosition());
    }

    @Override
    public boolean isEnableMove(MoveObject mo) {
        if (!this.level.getZoneGeomap(mo.getNowPos().zoneID).isEnableMove(this, mo)) {
            return false;
        }
        return !this.isCollision(mo);
    }

    @Override
    public boolean isCollision(MoveObject mo) {
        return this.shard.getSyncArea(mo.getNextPos()).isCollision(mo);
    }

    public void checkQuestTriger(PlayerCharactor pc, TriggerParameter param) throws PacketFormatException, IOException {
        int i = 0;
        while (i < pc.listQuest.length) {
            QuestPhase phase;
            Quest quest = pc.getQuest(i);
            if (quest != null && (phase = quest.getPhase()).trigger(param)) {
                Packet pac;
                quest.update();
                if (!quest.isComplete()) {
                    pac = PacketFactory.createQuestPacket(quest);
                    try {
                        pc.conn.send(pac);
                    }
                    catch (Throwable e) {
                        log.error("error in send packet, ", e);
                    }
                } else {
                    pc.listQuest[i] = null;
                    pc.listCompleteQuest.add(quest);
                    pac = PacketFactory.createQuestPacket(quest);
                    pc.conn.send(pac);
                    for (QuestReward reward : quest.listReward) {
                        Packet sendPacket;
                        if (!(reward instanceof QuestRewardGetItem)) continue;
                        QuestRewardGetItem reward2 = (QuestRewardGetItem)reward;
                        Item item = ItemFactory.createItem(reward2.itemId);
                        int slot = pc.addItem(item);
                        if (slot == -1) {
                            sendPacket = PacketFactory.createMessagePacket(new ChatMessage(0, 0));
                            pc.conn.send(sendPacket);
                            continue;
                        }
                        sendPacket = PacketFactory.createGetItemStatusPacket(slot, item);
                        pc.conn.send(sendPacket);
                    }
                }
            }
            ++i;
        }
    }
}

