/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import jp.sourceforge.mmosf.server.object.Vector;

public class Position {
    private final double x;
    private final double y;
    private final double z;
    public int zoneID;
    public int shardID;

    public Position() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Position(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.zoneID = 0;
        this.shardID = 0;
    }

    public Position getMoved(Vector v) {
        return new Position(this.x + v.getdX(), this.y + v.getdY(), this.z + v.getdZ());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.shardID;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.zoneID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Position) {
            Position pos = (Position)obj;
            return this.getX() == pos.getX() && this.getY() == pos.getY() && this.getZ() == pos.getZ();
        }
        return false;
    }

    public String toString() {
        return "x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",zone=" + this.zoneID + ",shard=" + this.shardID;
    }

    public String toString2() {
        return String.valueOf(this.getX()) + "," + this.getY() + "," + this.getZ();
    }

    public static Position valueOf(String string) {
        if (string == null || string.length() == 0) {
            return new Position();
        }
        String[] split = string.split(",");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        while (split != null && i < split.length) {
            String[] value;
            if (split[i] != null && split[i].length() != 0 && (value = split[i].split("=")) != null && value.length >= 2 && value[0] != null) {
                if (value[0].equalsIgnoreCase("x")) {
                    x = Double.valueOf(value[1]);
                } else if (value[0].equalsIgnoreCase("y")) {
                    y = Double.valueOf(value[1]);
                } else if (value[0].equalsIgnoreCase("z")) {
                    z = Double.valueOf(value[1]);
                }
            }
            ++i;
        }
        return new Position(x, y, z);
    }

    public static Position valueOf2(String string) {
        if (string == null || string.length() == 0) {
            return new Position();
        }
        String[] split = string.split(",");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        while (split != null && i < split.length) {
            switch (i) {
                case 0: {
                    x = Integer.valueOf(split[i]).intValue();
                    break;
                }
                case 1: {
                    y = Integer.valueOf(split[i]).intValue();
                    break;
                }
                case 2: {
                    z = Integer.valueOf(split[i]).intValue();
                }
            }
            ++i;
        }
        return new Position(x, y, z);
    }

    public Position getSubtracted(Position p) {
        return new Position(this.x - p.x, this.y - p.y, this.z - p.z);
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public int getZ() {
        return (int)this.z;
    }

    public Vector getVector(Position next, double speed) {
        double x = next.x - this.x;
        double y = next.y - this.y;
        double z = next.z - this.z;
        double length = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        if (length == 0.0) {
            return Vector.ZERO;
        }
        double a = speed / length;
        Vector vec = new Vector(new Vector(x, y, z), a);
        return vec;
    }

    public Vector getVector(Position next) {
        return new Vector(next.x - this.x, next.y - this.y, next.z - this.z);
    }
}

