/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.WindowsDirectInputDeviceObjectCallback;

abstract class WindowsDirectInputDevice {
    public static final int DISCL_EXCLUSIVE = 1;
    public static final int DISCL_NONEXCLUSIVE = 2;
    public static final int DISCL_FOREGROUND = 4;
    public static final int DISCL_BACKGROUND = 8;
    public static final int DISCL_NOWINKEY = 16;
    public static final int GUID_XAxis = 1;
    public static final int GUID_YAxis = 2;
    public static final int GUID_ZAxis = 3;
    public static final int GUID_Button = 4;
    public static final int GUID_Unknown = 5;
    public static final int DATA_SIZE = 3;
    private final long di_device;
    private ByteBuffer event_buffer;

    public WindowsDirectInputDevice(long di_device) {
        this.di_device = di_device;
    }

    public void release() {
        this.release(this.di_device);
    }

    protected abstract void release(long var1);

    public int poll() {
        return this.poll(this.di_device);
    }

    protected abstract int poll(long var1);

    public void setDataFormat(int type) throws LWJGLException {
        int ret = this.setDataFormat(this.di_device, type);
        if (ret != 0) {
            throw new LWJGLException("Failed to set data format (" + Integer.toHexString(ret) + ")");
        }
    }

    protected abstract int setDataFormat(long var1, int var3);

    public void setCooperateLevel(long hwnd, int flags) throws LWJGLException {
        int ret = this.setCooperativeLevel(this.di_device, hwnd, flags);
        if (ret != 0) {
            throw new LWJGLException("Failed to set cooperative level (" + Integer.toHexString(ret) + ")");
        }
    }

    protected abstract int setCooperativeLevel(long var1, long var3, int var5);

    public int acquire() {
        return this.acquire(this.di_device);
    }

    protected abstract int acquire(long var1);

    public void setBufferSize(int buffer_size) throws LWJGLException {
        int ret = this.setBufferSize(this.di_device, buffer_size);
        if (ret != 0 && ret != 1 && ret != 2) {
            throw new LWJGLException("Failed to set buffer size (" + Integer.toHexString(ret) + ")");
        }
        int event_buffer_size = this.getEventSize() * buffer_size;
        this.event_buffer = BufferUtils.createByteBuffer(event_buffer_size);
    }

    protected abstract int setBufferSize(long var1, int var3);

    public int getDeviceData(IntBuffer buffer) {
        int events_remaining = buffer.remaining() / 3;
        if (this.event_buffer == null || events_remaining > this.event_buffer.remaining() / this.getEventSize()) {
            this.event_buffer = BufferUtils.createByteBuffer(events_remaining * this.getEventSize());
        }
        return this.getDeviceData(this.di_device, this.event_buffer, this.event_buffer.capacity(), buffer, buffer.position(), buffer.remaining());
    }

    protected abstract int getDeviceData(long var1, ByteBuffer var3, int var4, IntBuffer var5, int var6, int var7);

    public int getDeviceState(ByteBuffer buffer) {
        return this.getDeviceState(this.di_device, buffer, buffer.position(), buffer.remaining());
    }

    protected abstract int getDeviceState(long var1, ByteBuffer var3, int var4, int var5);

    public void unacquire() {
        this.unacquire(this.di_device);
    }

    protected abstract int unacquire(long var1);

    public int enumObjects(WindowsDirectInputDeviceObjectCallback enumerator) {
        return this.enumObjects(this.di_device, enumerator);
    }

    protected abstract int enumObjects(long var1, WindowsDirectInputDeviceObjectCallback var3);

    protected abstract int getEventSize();
}

