/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.client.sample;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InputProcess
implements Runnable,
KeyListener {
    private static Log log = LogFactory.getLog(InputProcess.class);
    protected KeyEvent keyEvent;
    protected BlockingQueue<Vector> queueMove = new LinkedBlockingQueue<Vector>();
    protected static final int QUEUE_SIZE = 3;
    protected final int interval = 100;

    public void keyTyped(KeyEvent e) {
    }

    protected boolean isArrowKey(KeyEvent e) {
        boolean isArrowKey = false;
        switch (e.getKeyCode()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                isArrowKey = true;
            }
        }
        return isArrowKey;
    }

    public abstract void send(Packet var1);

    public void move(int keyCode) {
        Vector v;
        switch (keyCode) {
            case 38: {
                v = Vector.NORTH;
                break;
            }
            case 40: {
                v = Vector.SOUTH;
                break;
            }
            case 37: {
                v = Vector.WEST;
                break;
            }
            case 39: {
                v = Vector.EAST;
                break;
            }
            default: {
                return;
            }
        }
        if (this.queueMove.size() < 3) {
            try {
                this.queueMove.put(v);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        try {
            if (this.queueMove.size() < 4) {
                this.queueMove.put(Vector.ZERO);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void keyReleased(KeyEvent e) {
        log.trace("release," + e.getKeyCode());
        if (this.isArrowKey(e)) {
            this.stop();
        }
        this.keyEvent = null;
    }

    public void keyPressed(KeyEvent e) {
        log.trace("pressed," + e.getKeyCode());
        if (!this.isKeyDown(e)) {
            return;
        }
        if (this.isArrowKey(e)) {
            this.move(e.getKeyCode());
        }
        this.keyEvent = e;
    }

    protected boolean isKeyDown(KeyEvent e) {
        if (this.keyEvent == null) {
            return true;
        }
        return this.keyEvent.getKeyCode() != e.getKeyCode();
    }

    public void run() {
        long next = System.nanoTime();
        while (true) {
            next += (long)(100 * 1000000);
            if (this.isLogout()) break;
            this.send();
            long end = System.nanoTime();
            long interval = next - end;
            if (interval < 0L) {
                log.warn("loop broken, InputProcess = " + (double)interval / 1.0E9);
                next += (long)(100 * 1000000);
                continue;
            }
            try {
                Thread.sleep(interval / 1000000L);
            }
            catch (InterruptedException e) {
                log.error("error in loop InputProcess sleep, ", e);
            }
            catch (Exception e) {
                log.error("error in loop InputProcess sleep, ", e);
            }
        }
    }

    public void send() {
        try {
            if (this.queueMove.isEmpty()) {
                return;
            }
            Vector v = this.queueMove.take();
            while (v.isZero()) {
                if (this.queueMove.isEmpty()) break;
                v = this.queueMove.take();
            }
            if (v != null) {
                Packet packet = PacketFactory.createMovePacket(v);
                this.send(packet);
            }
        }
        catch (InterruptedException e) {
            log.error("error in send move packet, ", e);
        }
        catch (Exception e) {
            log.error("error in send move packet, ", e);
        }
    }

    public abstract boolean isLogout();
}

