/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.Moving;
import jp.sourceforge.mmosf.server.object.MovingNo;
import jp.sourceforge.mmosf.server.object.MovingRnd;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.Visual;
import jp.sourceforge.mmosf.server.object.action.Action;
import jp.sourceforge.mmosf.server.object.dynamicaction.DynamicAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mob {
    static final Log log = LogFactory.getLog(Mob.class);
    public static final int COL_NO = 0;
    public static final int COL_ALL = 1;
    public static final int COL_PC = 2;
    public static final int COL_NPC = 3;
    private Position pos;
    public Vector direction;
    public Action act;
    public Visual vis;
    public int type;
    public DynamicAction dAct;
    public Moving moving;
    public char c;
    protected int id;
    public int colType = 1;

    public Mob(int x, int y, Character c, int id, int v) {
        this.pos = new Position();
        this.direction = new Vector(Vector.EAST);
        this.getPos().set(x, y, 0);
        this.c = c.charValue();
        this.id = id;
        this.act = new Action();
        this.vis = new Visual(v);
        this.moving = new MovingRnd();
        this.dAct = new DynamicAction();
    }

    public Mob(Mob mob) {
        this.type = mob.type;
        this.pos = new Position(mob.getPos());
        this.direction = new Vector(mob.direction);
        try {
            this.moving = (Moving)mob.moving.getClass().newInstance();
        }
        catch (Exception e) {
            log.error("error create moving, ", e);
            this.moving = new MovingNo();
        }
        this.c = mob.c;
        this.colType = mob.colType;
        this.act = mob.act;
        this.vis = mob.vis;
        this.id = mob.id;
        this.dAct = mob.dAct;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)obj;
        return this.type == mob.type && this.id == mob.id && this.getPos().equals(mob.getPos()) && this.direction.equals(mob.direction) && this.vis.getVtype() == mob.vis.getVtype();
    }

    public boolean isCollision(MoveObject mo) {
        if (this.isColType(0)) {
            return false;
        }
        return this.getPos().equals(mo.getNextPos());
    }

    public boolean isPlayerCharactor() {
        return false;
    }

    public boolean isColType(int colType) {
        return this.colType == colType;
    }

    public void move(MoveObject mo) {
        this.setPos(mo.getNextPos());
        if (mo.getVec() != null) {
            this.direction.set(mo.getVec().getDirection());
        }
    }

    public boolean isEnableMove(MoveObject mo, Perception prc) {
        if (mo.getVec().isZero()) {
            return false;
        }
        if (this.getPos().equals(mo.getNextPos())) {
            return true;
        }
        return prc.isEnableMove(mo);
    }

    public void setPos(Position pos) {
        this.pos.set(pos);
    }

    public Position getPos() {
        return this.pos;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ID=");
        sb.append(this.id);
        sb.append(":");
        sb.append("type=");
        sb.append(this.type);
        sb.append(":");
        sb.append("c=");
        sb.append(this.c);
        sb.append(":");
        sb.append("visual=");
        sb.append(this.vis.getVtype());
        sb.append(":");
        sb.append("pos=");
        sb.append(this.getPos().toString());
        sb.append(":");
        sb.append("direction=");
        sb.append(this.direction.toString());
        return sb.toString();
    }
}

