/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.Moving;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MovingVector
implements Moving {
    private Log log = LogFactory.getLog(MovingVector.class);
    protected double speed = 3.0;
    protected int moveType = 1;
    public Vector vec = new Vector();
    protected long time = System.currentTimeMillis();

    public double getSpeed() {
        return this.speed;
    }

    public boolean isMoveType(int moveType) {
        return this.moveType == moveType;
    }

    protected Vector getVector(Position nowPos) {
        if (!this.isMoveVector()) {
            this.time = System.currentTimeMillis();
            return Vector.ZERO;
        }
        long span = System.currentTimeMillis() - this.time;
        this.time = System.currentTimeMillis();
        double scale = (double)span * this.getSpeed() / 1000.0;
        Vector ret = new Vector();
        ret.x = this.vec.x * scale;
        ret.y = this.vec.y * scale;
        ret.z = this.vec.z * scale;
        return ret;
    }

    private boolean isMoveVector() {
        return !this.vec.isZero();
    }

    public MoveObject createMoveObject(Mob mob) {
        return new MoveObject(mob.getPos(), this.getVector(mob.getPos()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Mob mob, Perception prc) {
        MovingVector movingVector = this;
        synchronized (movingVector) {
            MoveObject mo1 = new MoveObject(new Position(mob.getPos()), this.getVector(mob.getPos()));
            Vector vec = this.getVectorPerFrame(mo1.getVec());
            do {
                MoveObject mo2;
                if (!mob.isEnableMove(mo2 = new MoveObject(new Position(mob.getPos()), vec), prc)) {
                    this.setVector(Vector.ZERO);
                    return;
                }
                mob.move(mo2);
            } while (!mob.getPos().equals(mo1.getNextPos()));
            this.time = System.currentTimeMillis();
            return;
        }
    }

    private Vector getVectorPerFrame(Vector vec) {
        if (vec.isLessOne()) {
            return vec;
        }
        return vec.getDirection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVector(Vector vec) {
        MovingVector movingVector = this;
        synchronized (movingVector) {
            this.vec.set(vec);
            this.time = System.currentTimeMillis();
        }
    }
}

