/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.sync;

import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.server.object.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaIndex {
    Integer x;
    Integer y;
    Integer z;
    public static final int AREA_SIZE = 10;

    public boolean equals(Object obj) {
        if (!(obj instanceof AreaIndex)) {
            return super.equals(obj);
        }
        AreaIndex index = (AreaIndex)obj;
        return this.x == index.x && this.y == index.y && this.z == index.z;
    }

    public static AreaIndex getAreaIndex(Position pos) {
        AreaIndex index = new AreaIndex();
        index.x = AreaIndex.getXIndex(pos);
        index.y = AreaIndex.getYIndex(pos);
        index.z = AreaIndex.getZIndex(pos);
        return index;
    }

    AreaIndex() {
    }

    AreaIndex(AreaIndex index) {
        this.x = index.x;
        this.y = index.y;
        this.z = index.z;
    }

    public static List<AreaIndex> getAreaIndexAround(Position pos) {
        return AreaIndex.getAreaIndexAround(AreaIndex.getAreaIndex(pos));
    }

    public static List<AreaIndex> getAreaIndexAround(AreaIndex center) {
        LinkedList<AreaIndex> list = new LinkedList<AreaIndex>();
        int offset = 0;
        if (!AreaIndex.isHalfStartLine(AreaIndex.add(center.y, -1))) {
            offset = -1;
        }
        AreaIndex ul = new AreaIndex(center);
        ul.y = AreaIndex.add(ul.y, -1);
        ul.x = AreaIndex.add(ul.x, offset);
        list.add(ul);
        AreaIndex ur = new AreaIndex(ul);
        ur.x = AreaIndex.add(ur.x, 1);
        list.add(ur);
        AreaIndex ml = new AreaIndex(center);
        ml.x = AreaIndex.add(ml.x, -1);
        list.add(ml);
        AreaIndex mr = new AreaIndex(center);
        mr.x = AreaIndex.add(mr.x, 1);
        list.add(mr);
        AreaIndex dl = new AreaIndex(center);
        dl.y = AreaIndex.add(dl.y, 1);
        dl.x = AreaIndex.add(dl.x, offset);
        list.add(dl);
        AreaIndex dr = new AreaIndex(dl);
        dr.x = AreaIndex.add(dr.x, 1);
        list.add(dr);
        return list;
    }

    private static Integer add(Integer value1, int value2) {
        return value1 + value2;
    }

    protected static Integer getZIndex(Position pos) {
        return 0;
    }

    protected static Integer getYIndex(Position pos) {
        int y2 = pos.getY() / 10;
        if (pos.getY() < 0) {
            --y2;
        }
        return y2;
    }

    protected static Integer getXIndex(Position pos) {
        int x = 0;
        x = AreaIndex.isHalfStartLine(AreaIndex.getYIndex(pos)) ? (pos.getX() + 5) / 10 : pos.getX() / 10;
        if (pos.getX() < 0) {
            --x;
        }
        return x;
    }

    public static boolean isHalfStartLine(Integer index) {
        return index % 2 != 0;
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getY() {
        return this.y;
    }

    public Integer getZ() {
        return this.z;
    }

    public String toString() {
        return "x=" + this.x.toString() + ",y=" + this.y.toString() + ",z=" + this.z.toString();
    }
}

