/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.state.TextureState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;

public class TextureAnimationController
extends Controller {
    private static final long serialVersionUID = -3669101429356423878L;
    private Texture[] textures;
    private Vector3f translationDelta;
    private float rotationDelta;
    private Vector3f textureRotationAxis;
    private float xRepeat;
    private float yRepeat;
    private float zRepeat;
    private Vector3f currentTranslation;
    private float currentRotationAngle;
    private Quaternion currentRotation;

    public TextureAnimationController() {
    }

    public TextureAnimationController(TextureState textureState) {
        this.textures = new Texture[textureState.getNumberOfSetTextures()];
        int n = 0;
        for (int i = 0; i < TextureState.getNumberOfTotalUnits(); ++i) {
            Texture texture = textureState.getTexture(i);
            if (texture == null) continue;
            this.textures[n++] = texture;
        }
        this.initializeValues();
    }

    public TextureAnimationController(Texture ... textureArray) {
        this.textures = textureArray;
        this.initializeValues();
    }

    private void initializeValues() {
        this.currentTranslation = new Vector3f();
        this.currentRotation = new Quaternion();
        this.translationDelta = new Vector3f();
        this.textureRotationAxis = new Vector3f();
        this.textureRotationAxis.z = 1.0f;
        this.xRepeat = 1.0f;
        this.yRepeat = 1.0f;
        this.zRepeat = 1.0f;
    }

    public void update(float f) {
        if (this.isActive()) {
            if (this.getRepeatType() == 1) {
                if (this.translationDelta.x != 0.0f || this.translationDelta.y != 0.0f || this.translationDelta.z != 0.0f) {
                    this.currentTranslation.x += this.getSpeed() * f * this.translationDelta.x;
                    this.currentTranslation.y += this.getSpeed() * f * this.translationDelta.y;
                    this.currentTranslation.z += this.getSpeed() * f * this.translationDelta.z;
                    if (this.currentTranslation.x > this.xRepeat || this.currentTranslation.x < -1.0f * this.xRepeat) {
                        this.currentTranslation.x = 0.0f;
                    }
                    if (this.currentTranslation.y > this.yRepeat || this.currentTranslation.y < -1.0f * this.yRepeat) {
                        this.currentTranslation.y = 0.0f;
                    }
                    if (this.currentTranslation.z > this.zRepeat || this.currentTranslation.z < -1.0f * this.zRepeat) {
                        this.currentTranslation.z = 0.0f;
                    }
                }
                if (this.rotationDelta != 0.0f) {
                    this.currentRotationAngle += this.rotationDelta * this.getSpeed() * f;
                    if (this.currentRotationAngle > (float)Math.PI * 2) {
                        this.currentRotationAngle = 0.0f;
                    } else if (this.currentRotationAngle < 0.0f) {
                        this.currentRotationAngle = (float)Math.PI * 2;
                    }
                    this.currentRotation.fromAngleNormalAxis(this.currentRotationAngle, this.textureRotationAxis);
                }
            } else if (this.getRepeatType() == 0) {
                if (this.translationDelta.x != 0.0f || this.translationDelta.y != 0.0f || this.translationDelta.z != 0.0f) {
                    if (this.currentTranslation.x <= this.xRepeat && this.currentTranslation.x >= -1.0f * this.xRepeat) {
                        this.currentTranslation.x += this.getSpeed() * f * this.translationDelta.x;
                    }
                    if (this.currentTranslation.y <= this.yRepeat && this.currentTranslation.y >= -1.0f * this.yRepeat) {
                        this.currentTranslation.y += this.getSpeed() * f * this.translationDelta.y;
                    }
                    if (this.currentTranslation.z <= this.zRepeat && this.currentTranslation.z >= -1.0f * this.zRepeat) {
                        this.currentTranslation.z += this.getSpeed() * f * this.translationDelta.z;
                    }
                }
                if (this.rotationDelta != 0.0f && this.currentRotationAngle <= (float)Math.PI * 2) {
                    this.currentRotationAngle += this.rotationDelta * this.getSpeed() * f;
                    this.currentRotation.fromAngleNormalAxis(this.currentRotationAngle, this.textureRotationAxis);
                }
            } else if (this.getRepeatType() == 2) {
                if (this.translationDelta.x != 0.0f || this.translationDelta.y != 0.0f || this.translationDelta.z != 0.0f) {
                    if (this.currentTranslation.x > this.xRepeat || this.currentTranslation.x < -1.0f * this.xRepeat) {
                        this.translationDelta.x *= -1.0f;
                    }
                    if (this.currentTranslation.y > this.yRepeat || this.currentTranslation.y < -1.0f * this.yRepeat) {
                        this.translationDelta.y *= -1.0f;
                    }
                    if (this.currentTranslation.z > this.zRepeat || this.currentTranslation.z < -1.0f * this.zRepeat) {
                        this.translationDelta.z *= -1.0f;
                    }
                    this.currentTranslation.x += this.getSpeed() * f * this.translationDelta.x;
                    this.currentTranslation.y += this.getSpeed() * f * this.translationDelta.y;
                    this.currentTranslation.z += this.getSpeed() * f * this.translationDelta.z;
                }
                if (this.rotationDelta != 0.0f) {
                    if (this.currentRotationAngle > (float)Math.PI * 2 || this.currentRotationAngle < 0.0f) {
                        this.rotationDelta *= -1.0f;
                    }
                    this.currentRotationAngle += this.rotationDelta * this.getSpeed() * f;
                    this.currentRotation.fromAngleNormalAxis(this.currentRotationAngle, this.textureRotationAxis);
                }
            }
            for (int i = 0; i < this.textures.length; ++i) {
                this.textures[i].setTranslation(this.currentTranslation);
                this.textures[i].setRotation(this.currentRotation);
            }
        }
    }

    public float getRotationDelta() {
        return this.rotationDelta;
    }

    public void setRotationDelta(float f) {
        this.rotationDelta = f;
    }

    public Vector3f getTranslationDelta() {
        return this.translationDelta;
    }

    public void setTranslationDelta(Vector3f vector3f) {
        this.translationDelta = vector3f;
    }

    public float getXRepeat() {
        return this.xRepeat;
    }

    public void setXRepeat(float f) {
        this.xRepeat = f;
    }

    public float getYRepeat() {
        return this.yRepeat;
    }

    public void setYRepeat(float f) {
        this.yRepeat = f;
    }

    public float getZRepeat() {
        return this.zRepeat;
    }

    public void setZRepeat(float f) {
        this.zRepeat = f;
    }

    public Vector3f getTextureRotationAxis() {
        return this.textureRotationAxis;
    }

    public void setTextureRotationAxis(Vector3f vector3f) {
        this.textureRotationAxis = vector3f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.translationDelta, "translationDelta", null);
        outputCapsule.write(this.rotationDelta, "rotationDelta", 0.0f);
        outputCapsule.write(this.textureRotationAxis, "textureRotationAxis", null);
        outputCapsule.write(this.xRepeat, "xRepeat", 1.0f);
        outputCapsule.write(this.yRepeat, "yRepeat", 1.0f);
        outputCapsule.write(this.zRepeat, "zRepeat", 1.0f);
        outputCapsule.write(this.currentTranslation, "currentTranslation", null);
        outputCapsule.write(this.currentRotation, "currentRotation", null);
        outputCapsule.write(this.currentRotationAngle, "currentRotationAngle", 0.0f);
        outputCapsule.write(this.textures, "textures", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.translationDelta = (Vector3f)inputCapsule.readSavable("translationDelta", null);
        this.rotationDelta = inputCapsule.readFloat("rotationDelta", 0.0f);
        this.textureRotationAxis = (Vector3f)inputCapsule.readSavable("textureRotationAxis", null);
        this.xRepeat = inputCapsule.readFloat("xRepeat", 1.0f);
        this.yRepeat = inputCapsule.readFloat("yRepeat", 1.0f);
        this.zRepeat = inputCapsule.readFloat("zRepeat", 1.0f);
        this.currentTranslation = (Vector3f)inputCapsule.readSavable("currentTranslation", null);
        this.currentRotation = (Quaternion)inputCapsule.readSavable("currentRotation", null);
        this.currentRotationAngle = inputCapsule.readFloat("currentRotationAngle", 0.0f);
        Savable[] savableArray = inputCapsule.readSavableArray("textures", null);
        if (savableArray != null) {
            this.textures = new Texture[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                this.textures[i] = (Texture)savableArray[i];
            }
        }
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

