/*
 * Decompiled with CFR 0.152.
 */
package com.jme.curve;

import com.jme.curve.Curve;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class CurveController
extends Controller {
    private static final long serialVersionUID = 1L;
    private Spatial mover;
    private Curve curve;
    private Vector3f up;
    private float orientationPrecision = 0.1f;
    private float currentTime = 0.0f;
    private float deltaTime = 0.0f;
    private boolean cycleForward = true;
    private boolean autoRotation = false;

    public CurveController(Curve curve, Spatial spatial) {
        this.curve = curve;
        this.mover = spatial;
        this.setUpVector(new Vector3f(0.0f, 1.0f, 0.0f));
        this.setMinTime(0.0f);
        this.setMaxTime(Float.MAX_VALUE);
        this.setRepeatType(0);
        this.setSpeed(1.0f);
    }

    public CurveController(Curve curve, Spatial spatial, float f, float f2) {
        this.curve = curve;
        this.mover = spatial;
        this.setMinTime(f);
        this.setMaxTime(f2);
        this.setRepeatType(0);
    }

    public void setUpVector(Vector3f vector3f) {
        this.up = vector3f;
    }

    public void setOrientationPrecision(float f) {
        this.orientationPrecision = f;
    }

    public void setAutoRotation(boolean bl) {
        this.autoRotation = bl;
    }

    public boolean isAutoRotating() {
        return this.autoRotation;
    }

    public void update(float f) {
        if (this.mover == null || this.curve == null || this.up == null) {
            return;
        }
        this.currentTime += f * this.getSpeed();
        if (this.currentTime >= this.getMinTime() && this.currentTime <= this.getMaxTime()) {
            if (this.getRepeatType() == 0) {
                this.deltaTime = this.currentTime - this.getMinTime();
                this.mover.setLocalTranslation(this.curve.getPoint(this.deltaTime, this.mover.getLocalTranslation()));
                if (this.autoRotation) {
                    this.mover.setLocalRotation(this.curve.getOrientation(this.deltaTime, this.orientationPrecision, this.up));
                }
            } else if (this.getRepeatType() == 1) {
                this.deltaTime = (this.currentTime - this.getMinTime()) % 1.0f;
                if (this.deltaTime > 1.0f) {
                    this.currentTime = 0.0f;
                    this.deltaTime = 0.0f;
                }
                this.mover.setLocalTranslation(this.curve.getPoint(this.deltaTime, this.mover.getLocalTranslation()));
                if (this.autoRotation) {
                    this.mover.setLocalRotation(this.curve.getOrientation(this.deltaTime, this.orientationPrecision, this.up));
                }
            } else if (this.getRepeatType() == 2) {
                float f2 = this.deltaTime;
                this.deltaTime = (this.currentTime - this.getMinTime()) % 1.0f;
                if (f2 > this.deltaTime) {
                    boolean bl = this.cycleForward = !this.cycleForward;
                }
                if (this.cycleForward) {
                    this.mover.setLocalTranslation(this.curve.getPoint(this.deltaTime, this.mover.getLocalTranslation()));
                    if (this.autoRotation) {
                        this.mover.setLocalRotation(this.curve.getOrientation(this.deltaTime, this.orientationPrecision, this.up));
                    }
                } else {
                    this.mover.setLocalTranslation(this.curve.getPoint(1.0f - this.deltaTime, this.mover.getLocalTranslation()));
                    if (this.autoRotation) {
                        this.mover.setLocalRotation(this.curve.getOrientation(1.0f - this.deltaTime, this.orientationPrecision, this.up));
                    }
                }
            } else {
                return;
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.mover, "mover", null);
        outputCapsule.write(this.curve, "Curve", null);
        outputCapsule.write(this.up, "up", null);
        outputCapsule.write(this.orientationPrecision, "orientationPrecision", 0.1f);
        outputCapsule.write(this.cycleForward, "cycleForward", true);
        outputCapsule.write(this.autoRotation, "autoRotation", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.mover = (Spatial)inputCapsule.readSavable("mover", null);
        this.curve = (Curve)inputCapsule.readSavable("curve", null);
        this.up = (Vector3f)inputCapsule.readSavable("up", null);
        this.orientationPrecision = inputCapsule.readFloat("orientationPrecision", 0.1f);
        this.cycleForward = inputCapsule.readBoolean("cycleForward", true);
        this.autoRotation = inputCapsule.readBoolean("autoRotation", false);
    }
}

