/*
 * Decompiled with CFR 0.152.
 */
package com.jme.image;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Image
implements Serializable,
Savable {
    private static final long serialVersionUID = -2496120296189166346L;
    public static final int GUESS_FORMAT_NO_S3TC = -2;
    public static final int GUESS_FORMAT = -1;
    public static final int RGBA4444 = 0;
    public static final int RGB888 = 1;
    public static final int RGBA5551 = 2;
    public static final int RGBA8888 = 3;
    public static final int RA88 = 4;
    public static final int RGB888_DXT1 = 5;
    public static final int RGBA8888_DXT1A = 6;
    public static final int RGBA8888_DXT3 = 7;
    public static final int RGBA8888_DXT5 = 8;
    public static final int LAST_UNCOMPRESSED_TYPE = 8;
    public static final int DXT1_NATIVE = 9;
    public static final int DXT1A_NATIVE = 10;
    public static final int DXT3_NATIVE = 11;
    public static final int DXT5_NATIVE = 12;
    public static final int LAST_TYPE = 12;
    protected int type;
    protected int width;
    protected int height;
    protected int[] mipMapSizes;
    protected transient ByteBuffer data;

    public Image() {
    }

    public Image(int n, int n2, int n3, ByteBuffer byteBuffer, int[] nArray) {
        if (n < 0 || n > 12) {
            n = 0;
        }
        if (nArray != null && nArray.length <= 1) {
            nArray = null;
        }
        this.type = n;
        this.width = n2;
        this.height = n3;
        this.data = byteBuffer;
        this.mipMapSizes = nArray;
    }

    public Image(int n, int n2, int n3, ByteBuffer byteBuffer) {
        this(n, n2, n3, byteBuffer, null);
    }

    public void setData(ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    public void setMipMapSizes(int[] nArray) {
        if (nArray != null && nArray.length <= 1) {
            nArray = null;
        }
        this.mipMapSizes = nArray;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setType(int n) {
        if (n < 0 || n > 12) {
            n = 0;
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCompressedType() {
        return this.type > 8;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public boolean hasMipmaps() {
        return this.mipMapSizes != null;
    }

    public int[] getMipMapSizes() {
        return this.mipMapSizes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.getType() != image.getType()) {
            return false;
        }
        if (this.getWidth() != image.getWidth()) {
            return false;
        }
        if (this.getHeight() != image.getHeight()) {
            return false;
        }
        if (this.getData() != null && !this.getData().equals(image.getData())) {
            return false;
        }
        if (this.getData() == null && image.getData() != null) {
            return false;
        }
        if (this.getMipMapSizes() != null && !Arrays.equals(this.getMipMapSizes(), image.getMipMapSizes())) {
            return false;
        }
        return this.getMipMapSizes() != null || image.getMipMapSizes() == null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.data == null) {
            objectOutputStream.writeInt(0);
        } else {
            this.data.clear();
            objectOutputStream.writeInt(this.data.limit());
            byte[] byArray = new byte[this.data.limit()];
            this.data.get(byArray);
            objectOutputStream.write(byArray);
            objectOutputStream.flush();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.data = null;
        } else {
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            this.data = byteBuffer;
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.type, "type", 0);
        outputCapsule.write(this.width, "width", 0);
        outputCapsule.write(this.height, "height", 0);
        outputCapsule.write(this.mipMapSizes, "mipMapSizes", (int[])null);
        outputCapsule.write(this.data, "data", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.type = inputCapsule.readInt("type", 0);
        this.width = inputCapsule.readInt("width", 0);
        this.height = inputCapsule.readInt("height", 0);
        this.mipMapSizes = inputCapsule.readIntArray("mipMapSizes", null);
        this.data = inputCapsule.readByteBuffer("data", null);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

