/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.util;

import com.jme.input.InputHandler;
import com.jme.input.InputHandlerDevice;
import com.jme.input.action.InputActionInterface;
import com.jme.input.util.SyntheticAxis;
import com.jme.input.util.SyntheticButton;
import com.jme.input.util.SyntheticTriggerContainer;
import java.util.ArrayList;

class UtilInputHandlerDevice
extends InputHandlerDevice {
    public static final String DEVICE_UTIL = "Synthetic Input Device";
    private static UtilInputHandlerDevice instance;
    private ArrayList<SyntheticAxis> axes = new ArrayList();
    private ArrayList<SyntheticButton> buttons = new ArrayList();

    public UtilInputHandlerDevice() {
        super(DEVICE_UTIL);
    }

    protected void createTriggers(InputActionInterface inputActionInterface, int n, int n2, boolean bl, InputHandler inputHandler) {
        SyntheticTriggerContainer syntheticTriggerContainer;
        SyntheticTriggerContainer syntheticTriggerContainer2;
        if (n != -1) {
            if (n != Integer.MIN_VALUE) {
                syntheticTriggerContainer2 = this.axes.get(n);
                ((SyntheticAxis)syntheticTriggerContainer2).createTrigger(inputHandler, inputActionInterface, bl);
            } else {
                for (int i = this.axes.size() - 1; i >= 0; --i) {
                    syntheticTriggerContainer = this.axes.get(i);
                    ((SyntheticAxis)syntheticTriggerContainer).createTrigger(inputHandler, inputActionInterface, bl);
                }
            }
        }
        if (n2 != -1) {
            if (n2 != Integer.MIN_VALUE) {
                syntheticTriggerContainer2 = this.buttons.get(n2);
                ((SyntheticButton)syntheticTriggerContainer2).createTrigger(inputHandler, inputActionInterface, bl);
            } else {
                for (int i = this.buttons.size() - 1; i >= 0; --i) {
                    syntheticTriggerContainer = this.buttons.get(i);
                    ((SyntheticButton)syntheticTriggerContainer).createTrigger(inputHandler, inputActionInterface, bl);
                }
            }
        }
    }

    static UtilInputHandlerDevice get() {
        if (instance == null) {
            instance = new UtilInputHandlerDevice();
            InputHandler.addDevice(instance);
        }
        return instance;
    }

    void addAxis(SyntheticAxis syntheticAxis) {
        int n = this.axes.size();
        this.axes.add(syntheticAxis);
        syntheticAxis.setIndex(n);
    }

    void removeAxis(SyntheticAxis syntheticAxis) {
        if (this.axes.get(syntheticAxis.getIndex()) == syntheticAxis) {
            this.axes.set(syntheticAxis.getIndex(), null);
        }
    }

    void addButton(SyntheticButton syntheticButton) {
        int n = this.buttons.size();
        this.buttons.add(syntheticButton);
        syntheticButton.setIndex(n);
    }

    void removeButton(SyntheticButton syntheticButton) {
        if (this.buttons.get(syntheticButton.getIndex()) == syntheticButton) {
            this.buttons.set(syntheticButton.getIndex(), null);
        }
    }
}

