/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.bounding.BoundingVolume;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.Plane;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.LightState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightManagement
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    public static boolean LIGHTS_ENABLED = true;
    ArrayList<Light> lightList = new ArrayList();

    public void addLight(Light light) {
        this.lightList.add(light);
    }

    public boolean contains(Light light) {
        return this.lightList.contains(light);
    }

    public boolean removeLight(Light light) {
        return this.lightList.remove(light);
    }

    public Light get(int n) {
        return this.lightList.get(n);
    }

    public int numberOfLights() {
        return this.lightList.size();
    }

    public LightState createLightState(Spatial spatial) {
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        this.resortLightsFor(lightState, spatial);
        return lightState;
    }

    public void resortLightsFor(LightState lightState, Spatial spatial) {
        if (lightState == null) {
            return;
        }
        lightState.detachAll();
        if (LIGHTS_ENABLED && this.lightList.size() > 0) {
            lightState.setEnabled(true);
            this.sort(spatial);
        } else {
            lightState.setEnabled(false);
        }
        int n = Math.min(8, this.lightList.size());
        for (int i = 0; i < n; ++i) {
            lightState.attach(this.get(i));
        }
        spatial.updateRenderState();
        spatial.setLightCombineMode(1);
    }

    protected void sort(final Spatial spatial) {
        Collections.sort(this.lightList, new Comparator<Light>(){

            @Override
            public int compare(Light light, Light light2) {
                float f;
                float f2 = LightManagement.this.getValueFor(light, spatial.getWorldBound());
                float f3 = f2 - (f = LightManagement.this.getValueFor(light2, spatial.getWorldBound()));
                if (f3 > 1.1920929E-7f) {
                    return -1;
                }
                if (f3 < -1.1920929E-7f) {
                    return 1;
                }
                return 0;
            }
        });
    }

    protected float max(ColorRGBA colorRGBA) {
        return Math.max(Math.max(colorRGBA.r, colorRGBA.g), colorRGBA.b);
    }

    protected float getColorValue(Light light) {
        return Math.max(Math.max(this.max(light.getAmbient()), this.max(light.getDiffuse())), this.max(light.getSpecular()));
    }

    protected float getValueFor(Light light, BoundingVolume boundingVolume) {
        if (!light.isEnabled()) {
            return 0.0f;
        }
        if (light.getType() == 0) {
            return this.getColorValue(light);
        }
        if (light.getType() == 1) {
            return this.getValueFor((PointLight)light, boundingVolume);
        }
        if (light.getType() == 2) {
            return this.getValueFor((SpotLight)light, boundingVolume);
        }
        return 0.3f;
    }

    float getValueFor(PointLight pointLight, BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return 0.0f;
        }
        if (pointLight.isAttenuate() && boundingVolume != null) {
            float f = boundingVolume.distanceTo(pointLight.getLocation());
            float f2 = this.getColorValue(pointLight);
            float f3 = pointLight.getConstant() + pointLight.getLinear() * f + pointLight.getQuadratic() * f * f;
            return f2 / f3;
        }
        return this.getColorValue(pointLight);
    }

    float getValueFor(SpotLight spotLight, BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return 0.0f;
        }
        Plane plane = new Plane(spotLight.getDirection(), spotLight.getDirection().dot(spotLight.getLocation()));
        if (boundingVolume.whichSide(plane) != 2) {
            return this.getValueFor((PointLight)spotLight, boundingVolume);
        }
        return 0.0f;
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.lightList = inputCapsule.readSavableArrayList("lightList", new ArrayList());
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.lightList, "lightList", new ArrayList());
    }

    @Override
    public Class getClassTag() {
        return this.getClass();
    }

    public ArrayList<Light> getLights() {
        return this.lightList;
    }

    public void setLights(ArrayList<Light> arrayList) {
        this.lightList = arrayList;
    }

    public void reset() {
        this.lightList.clear();
    }
}

