/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;

public class Skybox
extends Node {
    private static final long serialVersionUID = 1L;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int UP = 4;
    public static final int DOWN = 5;
    private float xExtent;
    private float yExtent;
    private float zExtent;
    private Quad[] skyboxQuads;

    public Skybox() {
    }

    public Skybox(String string, float f, float f2, float f3) {
        super(string);
        this.xExtent = f;
        this.yExtent = f2;
        this.zExtent = f3;
        this.initialize();
    }

    public int getType() {
        return 17;
    }

    public void setTexture(int n, Texture texture) {
        if (n < 0 || n > 5) {
            throw new JmeException("Direction " + n + " is not a valid side for the skybox");
        }
        this.skyboxQuads[n].clearRenderState(6);
        this.setTexture(n, texture, 0);
    }

    public void setTexture(int n, Texture texture, int n2) {
        if (n < 0 || n > 5) {
            throw new JmeException("Direction " + n + " is not a valid side for the skybox");
        }
        TextureState textureState = (TextureState)this.skyboxQuads[n].getRenderState(6);
        if (textureState == null) {
            textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        }
        textureState.setTexture(texture, n2);
        textureState.setEnabled(true);
        this.skyboxQuads[n].setRenderState(textureState);
    }

    public Texture getTexture(int n) {
        if (n < 0 || n > 5 || this.skyboxQuads[n].getRenderState(6) == null) {
            return null;
        }
        return ((TextureState)this.skyboxQuads[n].getRenderState(6)).getTexture();
    }

    private void initialize() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.skyboxQuads = new Quad[6];
        this.skyboxQuads[0] = new Quad("north", this.xExtent * 2.0f, this.yExtent * 2.0f);
        this.skyboxQuads[0].setLocalRotation(new Quaternion(new float[]{0.0f, (float)Math.toRadians(180.0), 0.0f}));
        this.skyboxQuads[0].setLocalTranslation(new Vector3f(0.0f, 0.0f, this.zExtent));
        this.skyboxQuads[1] = new Quad("south", this.xExtent * 2.0f, this.yExtent * 2.0f);
        this.skyboxQuads[1].setLocalTranslation(new Vector3f(0.0f, 0.0f, -this.zExtent));
        this.skyboxQuads[2] = new Quad("east", this.zExtent * 2.0f, this.yExtent * 2.0f);
        this.skyboxQuads[2].setLocalRotation(new Quaternion(new float[]{0.0f, (float)Math.toRadians(90.0), 0.0f}));
        this.skyboxQuads[2].setLocalTranslation(new Vector3f(-this.xExtent, 0.0f, 0.0f));
        this.skyboxQuads[3] = new Quad("west", this.zExtent * 2.0f, this.yExtent * 2.0f);
        this.skyboxQuads[3].setLocalRotation(new Quaternion(new float[]{0.0f, (float)Math.toRadians(270.0), 0.0f}));
        this.skyboxQuads[3].setLocalTranslation(new Vector3f(this.xExtent, 0.0f, 0.0f));
        this.skyboxQuads[4] = new Quad("up", this.xExtent * 2.0f, this.zExtent * 2.0f);
        this.skyboxQuads[4].setLocalRotation(new Quaternion(new float[]{(float)Math.toRadians(90.0), (float)Math.toRadians(270.0), 0.0f}));
        this.skyboxQuads[4].setLocalTranslation(new Vector3f(0.0f, this.yExtent, 0.0f));
        this.skyboxQuads[5] = new Quad("down", this.xExtent * 2.0f, this.zExtent * 2.0f);
        this.skyboxQuads[5].setLocalRotation(new Quaternion(new float[]{(float)Math.toRadians(270.0), (float)Math.toRadians(270.0), 0.0f}));
        this.skyboxQuads[5].setLocalTranslation(new Vector3f(0.0f, -this.yExtent, 0.0f));
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
        ZBufferState zBufferState = displaySystem.getRenderer().createZBufferState();
        zBufferState.setWritable(false);
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.setRenderState(zBufferState);
        this.setCullMode(3);
        for (int i = 0; i < 6; ++i) {
            this.skyboxQuads[i].setTextureCombineMode(5);
            this.skyboxQuads[i].setLightCombineMode(0);
            this.skyboxQuads[i].setCullMode(3);
            this.skyboxQuads[i].setModelBound(new BoundingBox());
            this.skyboxQuads[i].updateModelBound();
            this.skyboxQuads[i].setRenderQueueMode(1);
            this.skyboxQuads[i].setVBOInfo(null);
            this.attachChild(this.skyboxQuads[i]);
        }
    }

    public Quad getSide(int n) {
        return this.skyboxQuads[n];
    }

    public void preloadTextures() {
        for (int i = 0; i < 6; ++i) {
            TextureState textureState = (TextureState)this.skyboxQuads[i].getRenderState(6);
            if (textureState == null) continue;
            textureState.apply();
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.xExtent, "xExtent", 0.0f);
        outputCapsule.write(this.yExtent, "yExtent", 0.0f);
        outputCapsule.write(this.zExtent, "zExtent", 0.0f);
        outputCapsule.write(this.skyboxQuads, "skyboxQuads", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.xExtent = inputCapsule.readFloat("xExtent", 0.0f);
        this.yExtent = inputCapsule.readFloat("yExtent", 0.0f);
        this.zExtent = inputCapsule.readFloat("zExtent", 0.0f);
        Savable[] savableArray = inputCapsule.readSavableArray("skyboxQuads", null);
        if (savableArray == null) {
            this.skyboxQuads = null;
            this.initialize();
        } else {
            this.skyboxQuads = new Quad[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                this.skyboxQuads[i] = (Quad)savableArray[i];
            }
        }
    }
}

