/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Box
extends TriMesh
implements Savable {
    private static final long serialVersionUID = 1L;
    public float xExtent;
    public float yExtent;
    public float zExtent;
    public final Vector3f center = new Vector3f(0.0f, 0.0f, 0.0f);

    public Box() {
        super("temp");
    }

    public Box(String string) {
        super(string);
    }

    public Box(String string, Vector3f vector3f, Vector3f vector3f2) {
        super(string);
        this.setData(vector3f, vector3f2);
    }

    public Box(String string, Vector3f vector3f, float f, float f2, float f3) {
        super(string);
        this.setData(vector3f, f, f2, f3);
    }

    public void setData(Vector3f vector3f, Vector3f vector3f2) {
        this.center.set(vector3f2).addLocal(vector3f).multLocal(0.5f);
        float f = vector3f2.x - this.center.x;
        float f2 = vector3f2.y - this.center.y;
        float f3 = vector3f2.z - this.center.z;
        this.setData(this.center, f, f2, f3);
    }

    public void setData(Vector3f vector3f, float f, float f2, float f3) {
        if (vector3f != null) {
            this.center.set(vector3f);
        }
        this.xExtent = f;
        this.yExtent = f2;
        this.zExtent = f3;
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void setVertexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), 24));
        triangleBatch.setVertexCount(24);
        Vector3f[] vector3fArray = this.computeVertices();
        triangleBatch.getVertexBuffer().put(vector3fArray[0].x).put(vector3fArray[0].y).put(vector3fArray[0].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[1].x).put(vector3fArray[1].y).put(vector3fArray[1].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[2].x).put(vector3fArray[2].y).put(vector3fArray[2].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[3].x).put(vector3fArray[3].y).put(vector3fArray[3].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[1].x).put(vector3fArray[1].y).put(vector3fArray[1].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[4].x).put(vector3fArray[4].y).put(vector3fArray[4].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[6].x).put(vector3fArray[6].y).put(vector3fArray[6].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[2].x).put(vector3fArray[2].y).put(vector3fArray[2].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[4].x).put(vector3fArray[4].y).put(vector3fArray[4].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[5].x).put(vector3fArray[5].y).put(vector3fArray[5].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[7].x).put(vector3fArray[7].y).put(vector3fArray[7].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[6].x).put(vector3fArray[6].y).put(vector3fArray[6].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[5].x).put(vector3fArray[5].y).put(vector3fArray[5].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[0].x).put(vector3fArray[0].y).put(vector3fArray[0].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[3].x).put(vector3fArray[3].y).put(vector3fArray[3].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[7].x).put(vector3fArray[7].y).put(vector3fArray[7].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[2].x).put(vector3fArray[2].y).put(vector3fArray[2].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[6].x).put(vector3fArray[6].y).put(vector3fArray[6].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[7].x).put(vector3fArray[7].y).put(vector3fArray[7].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[3].x).put(vector3fArray[3].y).put(vector3fArray[3].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[0].x).put(vector3fArray[0].y).put(vector3fArray[0].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[5].x).put(vector3fArray[5].y).put(vector3fArray[5].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[4].x).put(vector3fArray[4].y).put(vector3fArray[4].z);
        triangleBatch.getVertexBuffer().put(vector3fArray[1].x).put(vector3fArray[1].y).put(vector3fArray[1].z);
    }

    private void setNormalData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        if (triangleBatch.getNormalBuffer() == null) {
            int n;
            triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(24));
            for (n = 0; n < 4; ++n) {
                triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(-1.0f);
            }
            for (n = 0; n < 4; ++n) {
                triangleBatch.getNormalBuffer().put(1.0f).put(0.0f).put(0.0f);
            }
            for (n = 0; n < 4; ++n) {
                triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
            }
            for (n = 0; n < 4; ++n) {
                triangleBatch.getNormalBuffer().put(-1.0f).put(0.0f).put(0.0f);
            }
            for (n = 0; n < 4; ++n) {
                triangleBatch.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
            }
            for (n = 0; n < 4; ++n) {
                triangleBatch.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
            }
        }
    }

    private void setTextureData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        if (triangleBatch.getTextureBuffers().get(0) == null) {
            triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(24));
            FloatBuffer floatBuffer = triangleBatch.getTextureBuffers().get(0);
            for (int i = 0; i < 6; ++i) {
                floatBuffer.put(1.0f).put(0.0f);
                floatBuffer.put(0.0f).put(0.0f);
                floatBuffer.put(0.0f).put(1.0f);
                floatBuffer.put(1.0f).put(1.0f);
            }
        }
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        if (triangleBatch.getIndexBuffer() == null) {
            int[] nArray = new int[]{2, 1, 0, 3, 2, 0, 6, 5, 4, 7, 6, 4, 10, 9, 8, 11, 10, 8, 14, 13, 12, 15, 14, 12, 18, 17, 16, 19, 18, 16, 22, 21, 20, 23, 22, 20};
            triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(nArray));
        }
    }

    public Object clone() {
        Box box = new Box(this.getName() + "_clone", this.center.clone(), this.xExtent, this.yExtent, this.zExtent);
        return box;
    }

    public Vector3f[] computeVertices() {
        Vector3f[] vector3fArray = new Vector3f[]{Vector3f.UNIT_X.mult(this.xExtent), Vector3f.UNIT_Y.mult(this.yExtent), Vector3f.UNIT_Z.mult(this.zExtent)};
        Vector3f[] vector3fArray2 = new Vector3f[]{this.center.subtract(vector3fArray[0]).subtractLocal(vector3fArray[1]).subtractLocal(vector3fArray[2]), this.center.add(vector3fArray[0]).subtractLocal(vector3fArray[1]).subtractLocal(vector3fArray[2]), this.center.add(vector3fArray[0]).addLocal(vector3fArray[1]).subtractLocal(vector3fArray[2]), this.center.subtract(vector3fArray[0]).addLocal(vector3fArray[1]).subtractLocal(vector3fArray[2]), this.center.add(vector3fArray[0]).subtractLocal(vector3fArray[1]).addLocal(vector3fArray[2]), this.center.subtract(vector3fArray[0]).subtractLocal(vector3fArray[1]).addLocal(vector3fArray[2]), this.center.add(vector3fArray[0]).addLocal(vector3fArray[1]).addLocal(vector3fArray[2]), this.center.subtract(vector3fArray[0]).addLocal(vector3fArray[1]).addLocal(vector3fArray[2])};
        return vector3fArray2;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public void setCenter(Vector3f vector3f) {
        this.center.set(vector3f);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.xExtent, "xExtent", 0.0f);
        outputCapsule.write(this.yExtent, "yExtent", 0.0f);
        outputCapsule.write(this.zExtent, "zExtent", 0.0f);
        outputCapsule.write(this.center, "center", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.xExtent = inputCapsule.readFloat("xExtent", 0.0f);
        this.yExtent = inputCapsule.readFloat("yExtent", 0.0f);
        this.zExtent = inputCapsule.readFloat("zExtent", 0.0f);
        this.center.set((Vector3f)inputCapsule.readSavable("center", Vector3f.ZERO.clone()));
    }
}

