/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public abstract class WireframeState
extends RenderState {
    public static final int WS_FRONT_AND_BACK = 0;
    public static final int WS_FRONT = 1;
    public static final int WS_BACK = 2;
    protected int face = 0;
    protected float lineWidth = 1.0f;
    protected boolean antialiased = false;

    public int getType() {
        return 7;
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Line width must be positive");
        }
        this.lineWidth = f;
        this.setNeedsRefresh(true);
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setFace(int n) {
        this.face = n;
        this.setNeedsRefresh(true);
    }

    public int getFace() {
        return this.face;
    }

    public void setAntialiased(boolean bl) {
        this.antialiased = bl;
        this.setNeedsRefresh(true);
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.face, "face", 0);
        outputCapsule.write(this.lineWidth, "lineWidth", 1.0f);
        outputCapsule.write(this.antialiased, "antialiased", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.face = inputCapsule.readInt("face", 0);
        this.lineWidth = inputCapsule.readFloat("lineWidth", 1.0f);
        this.antialiased = inputCapsule.readBoolean("antialiased", false);
    }

    public Class getClassTag() {
        return WireframeState.class;
    }
}

