/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.export.binary;

import com.jme.math.FastMath;
import com.jme.util.export.ByteUtils;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryClassField;
import com.jme.util.export.binary.BinaryClassObject;
import com.jme.util.export.binary.BinaryIdContentPair;
import com.jme.util.export.binary.BinaryOutputCapsule;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryExporter
implements JMEExporter {
    private static final Logger logger = Logger.getLogger(BinaryExporter.class.getName());
    public static int COMPRESSION = 9;
    protected int aliasCount = 1;
    protected int idCount = 1;
    protected IdentityHashMap<Savable, BinaryIdContentPair> contentTable;
    protected HashMap<Integer, Integer> locationTable;
    private HashMap<String, BinaryClassObject> classes;
    private ArrayList<Savable> contentKeys = new ArrayList();
    public static boolean debug = false;

    public static BinaryExporter getInstance() {
        return new BinaryExporter();
    }

    @Override
    public boolean save(Savable savable, OutputStream outputStream) throws IOException {
        ArrayList<BinaryIdContentPair> arrayList;
        Object object;
        Object object2;
        Object object3;
        this.classes = new HashMap();
        this.contentTable = new IdentityHashMap();
        this.locationTable = new HashMap();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream){
            {
                this.def.setLevel(COMPRESSION);
            }
        };
        int n = this.processBinarySavable(savable);
        int n2 = 0;
        int n3 = this.classes.keySet().size();
        int n4 = (int)FastMath.log(n3, 256.0f) + 1;
        gZIPOutputStream.write(ByteUtils.convertToBytes(n3));
        for (String string : this.classes.keySet()) {
            object3 = this.classes.get(string);
            object2 = this.fixClassAlias(((BinaryClassObject)object3).alias, n4);
            gZIPOutputStream.write((byte[])object2);
            n2 += n4;
            object = string.getBytes();
            gZIPOutputStream.write(ByteUtils.convertToBytes(((Object)object).length));
            gZIPOutputStream.write((byte[])object);
            n2 += 4 + ((Object)object).length;
            gZIPOutputStream.write(ByteUtils.convertToBytes(((BinaryClassObject)object3).nameFields.size()));
            for (String object4 : ((BinaryClassObject)object3).nameFields.keySet()) {
                arrayList = ((BinaryClassObject)object3).nameFields.get(object4);
                gZIPOutputStream.write(((BinaryClassField)((Object)arrayList)).alias);
                gZIPOutputStream.write(((BinaryClassField)((Object)arrayList)).type);
                byte[] byArray = object4.getBytes();
                gZIPOutputStream.write(ByteUtils.convertToBytes(byArray.length));
                gZIPOutputStream.write(byArray);
                n2 += 6 + byArray.length;
            }
        }
        Object object5 = new ByteArrayOutputStream();
        int n5 = 0;
        object3 = new HashMap(this.contentTable.size());
        object2 = this.contentKeys.iterator();
        while (object2.hasNext()) {
            object = (Savable)object2.next();
            Iterator<String> iterator = object.getClassTag().getName();
            BinaryIdContentPair binaryIdContentPair = this.contentTable.get(object);
            int n6 = this.findPrevMatch(binaryIdContentPair, arrayList = (ArrayList)((HashMap)object3).get((String)((Object)iterator) + this.getChunk(binaryIdContentPair)));
            if (n6 != -1) {
                this.locationTable.put(binaryIdContentPair.getId(), n6);
                continue;
            }
            this.locationTable.put(binaryIdContentPair.getId(), n5);
            if (arrayList == null) {
                arrayList = new ArrayList<BinaryIdContentPair>();
                ((HashMap)object3).put(iterator + this.getChunk(binaryIdContentPair), arrayList);
            }
            arrayList.add(binaryIdContentPair);
            byte[] byArray = this.fixClassAlias(this.classes.get(iterator).alias, n4);
            ((OutputStream)object5).write(byArray);
            n5 += n4;
            BinaryOutputCapsule binaryOutputCapsule = this.contentTable.get(object).getContent();
            ((OutputStream)object5).write(ByteUtils.convertToBytes(binaryOutputCapsule.bytes.length));
            n5 += 4;
            ((OutputStream)object5).write(binaryOutputCapsule.bytes);
            n5 += binaryOutputCapsule.bytes.length;
        }
        int n7 = this.locationTable.keySet().size();
        gZIPOutputStream.write(ByteUtils.convertToBytes(n7));
        int n8 = 0;
        for (Integer n9 : this.locationTable.keySet()) {
            gZIPOutputStream.write(ByteUtils.convertToBytes(n9));
            gZIPOutputStream.write(ByteUtils.convertToBytes(this.locationTable.get(n9)));
            n8 += 8;
        }
        gZIPOutputStream.write(ByteUtils.convertToBytes(1));
        gZIPOutputStream.write(ByteUtils.convertToBytes(n));
        ((ByteArrayOutputStream)object5).writeTo(gZIPOutputStream);
        gZIPOutputStream.finish();
        object5 = null;
        gZIPOutputStream = null;
        if (debug) {
            logger.info("Stats:");
            logger.info("classes: " + n3);
            logger.info("class table: " + n2 + " bytes");
            logger.info("objects: " + n7);
            logger.info("location table: " + n8 + " bytes");
            logger.info("data: " + n5 + " bytes");
        }
        return true;
    }

    protected String getChunk(BinaryIdContentPair binaryIdContentPair) {
        return new String(binaryIdContentPair.getContent().bytes, 0, Math.min(64, binaryIdContentPair.getContent().bytes.length));
    }

    protected int findPrevMatch(BinaryIdContentPair binaryIdContentPair, ArrayList<BinaryIdContentPair> arrayList) {
        if (arrayList == null) {
            return -1;
        }
        int n = arrayList.size();
        while (--n >= 0) {
            BinaryIdContentPair binaryIdContentPair2 = arrayList.get(n);
            if (!binaryIdContentPair2.getContent().equals(binaryIdContentPair.getContent())) continue;
            return this.locationTable.get(binaryIdContentPair2.getId());
        }
        return -1;
    }

    protected byte[] fixClassAlias(byte[] byArray, int n) {
        if (byArray.length != n) {
            byte[] byArray2 = new byte[n];
            for (int i = n - byArray.length; i < n; ++i) {
                byArray2[i] = byArray[i - byArray.length];
            }
            return byArray2;
        }
        return byArray;
    }

    @Override
    public boolean save(Savable savable, File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        boolean bl = this.save(savable, fileOutputStream);
        fileOutputStream.close();
        return bl;
    }

    @Override
    public BinaryOutputCapsule getCapsule(Savable savable) {
        return this.contentTable.get(savable).getContent();
    }

    public int processBinarySavable(Savable savable) throws IOException {
        if (savable == null) {
            return -1;
        }
        BinaryClassObject binaryClassObject = this.classes.get(savable.getClassTag().getName());
        if (binaryClassObject == null) {
            binaryClassObject = new BinaryClassObject();
            binaryClassObject.alias = this.generateTag();
            binaryClassObject.nameFields = new HashMap();
            this.classes.put(savable.getClassTag().getName(), binaryClassObject);
        }
        if (this.contentTable.get(savable) != null) {
            return this.contentTable.get(savable).getId();
        }
        BinaryIdContentPair binaryIdContentPair = this.generateIdContentPair(binaryClassObject);
        BinaryIdContentPair binaryIdContentPair2 = this.contentTable.put(savable, binaryIdContentPair);
        if (binaryIdContentPair2 == null) {
            this.contentKeys.add(savable);
        }
        savable.write(this);
        binaryIdContentPair.getContent().finish();
        return binaryIdContentPair.getId();
    }

    protected byte[] generateTag() {
        int n = (int)FastMath.log(this.aliasCount, 256.0f) + 1;
        int n2 = this.aliasCount++;
        byte[] byArray = new byte[n];
        for (int i = n - 1; i >= 0; --i) {
            int n3 = (int)FastMath.pow(256.0f, i);
            int n4 = n2 / n3;
            byArray[n - i - 1] = (byte)n4;
            n2 %= n3;
        }
        return byArray;
    }

    protected BinaryIdContentPair generateIdContentPair(BinaryClassObject binaryClassObject) {
        BinaryIdContentPair binaryIdContentPair = new BinaryIdContentPair(this.idCount++, new BinaryOutputCapsule(this, binaryClassObject));
        return binaryIdContentPair;
    }
}

