/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.scene.Geometry;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Capsule;
import com.jme.scene.shape.OrientedBox;
import com.jme.scene.shape.Quad;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public final class Debugger {
    private static final Sphere boundingSphere = new Sphere("bsphere", 10, 10, 1.0f);
    private static final Box boundingBox;
    private static final OrientedBox boundingOB;
    private static final Capsule boundingCapsule;
    private static WireframeState boundsWireState;
    private static ZBufferState boundsZState;
    private static final Vector3f start;
    private static final Vector3f end;
    private static final Line normalLines;
    private static final Vector3f _normalVect;
    private static ZBufferState normZState;
    public static ColorRGBA NORMAL_COLOR_BASE;
    public static ColorRGBA NORMAL_COLOR_TIP;
    public static ColorRGBA TANGENT_COLOR_BASE;
    public static BoundingBox measureBox;
    public static float AUTO_NORMAL_RATIO;
    public static final int NORTHWEST = 0;
    public static final int NORTHEAST = 1;
    public static final int SOUTHEAST = 2;
    public static final int SOUTHWEST = 3;
    private static final Quad bQuad;
    private static Texture bufTexture;
    private static TextureRenderer bufTexRend;

    public static void drawBounds(SceneElement sceneElement, Renderer renderer) {
        Debugger.drawBounds(sceneElement, renderer, true);
    }

    public static void drawBounds(SceneElement sceneElement, Renderer renderer, boolean bl) {
        block9: {
            Geometry geometry;
            block8: {
                if (sceneElement == null) {
                    return;
                }
                if (boundsWireState == null) {
                    boundsWireState = renderer.createWireframeState();
                    boundsZState = renderer.createZBufferState();
                    boundingBox.setRenderState(boundsWireState);
                    boundingBox.setRenderState(boundsZState);
                    boundingBox.updateRenderState();
                    boundingOB.setRenderState(boundsWireState);
                    boundingOB.setRenderState(boundsZState);
                    boundingOB.updateRenderState();
                    boundingSphere.setRenderState(boundsWireState);
                    boundingSphere.setRenderState(boundsZState);
                    boundingSphere.updateRenderState();
                    boundingCapsule.setRenderState(boundsWireState);
                    boundingCapsule.setRenderState(boundsZState);
                    boundingCapsule.updateRenderState();
                }
                if (sceneElement.getWorldBound() != null && sceneElement.getCullMode() != 2) {
                    int n = renderer.getCamera().getPlaneState();
                    if (renderer.getCamera().contains(sceneElement.getWorldBound()) != 0) {
                        Debugger.drawBounds(sceneElement.getWorldBound(), renderer);
                    } else {
                        bl = false;
                    }
                    renderer.getCamera().setPlaneState(n);
                }
                if (!bl || (sceneElement.getType() & 1) == 0) break block8;
                Node node = (Node)sceneElement;
                if (node.getChildren() == null) break block9;
                int n = node.getChildren().size();
                while (--n >= 0) {
                    Debugger.drawBounds(node.getChild(n), renderer, true);
                }
                break block9;
            }
            if (bl && (sceneElement.getType() & 2) != 0 && (geometry = (Geometry)sceneElement).getBatchCount() > 0) {
                int n = geometry.getBatchCount();
                while (--n >= 0) {
                    GeomBatch geomBatch = geometry.getBatch(n);
                    if (geomBatch == null || !geomBatch.isEnabled()) continue;
                    Debugger.drawBounds(geomBatch, renderer, true);
                }
            }
        }
    }

    private static void drawBounds(BoundingVolume boundingVolume, Renderer renderer) {
        switch (boundingVolume.getType()) {
            case 1: {
                Debugger.drawBoundingBox((BoundingBox)boundingVolume, renderer);
                break;
            }
            case 0: {
                Debugger.drawBoundingSphere((BoundingSphere)boundingVolume, renderer);
                break;
            }
            case 2: {
                Debugger.drawOBB((OrientedBoundingBox)boundingVolume, renderer);
                break;
            }
            case 3: {
                Debugger.drawBoundingCapsule((BoundingCapsule)boundingVolume, renderer);
                break;
            }
        }
    }

    public static void setBoundsColor(ColorRGBA colorRGBA) {
        boundingBox.setSolidColor(colorRGBA);
        boundingOB.setSolidColor(colorRGBA);
        boundingCapsule.setSolidColor(colorRGBA);
        boundingSphere.setSolidColor(colorRGBA);
    }

    private static void drawBoundingSphere(BoundingSphere boundingSphere, Renderer renderer) {
        Debugger.boundingSphere.getCenter().set(boundingSphere.getCenter());
        Debugger.boundingSphere.setData(Debugger.boundingSphere.getCenter(), 10, 10, boundingSphere.getRadius());
        Debugger.boundingSphere.draw(renderer);
    }

    private static void drawBoundingBox(BoundingBox boundingBox, Renderer renderer) {
        Debugger.boundingBox.getCenter().set(boundingBox.getCenter());
        Debugger.boundingBox.setData(Debugger.boundingBox.getCenter(), boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent);
        Debugger.boundingBox.draw(renderer);
    }

    private static void drawOBB(OrientedBoundingBox orientedBoundingBox, Renderer renderer) {
        boundingOB.getCenter().set(orientedBoundingBox.getCenter());
        boundingOB.getxAxis().set(orientedBoundingBox.getXAxis());
        boundingOB.getyAxis().set(orientedBoundingBox.getYAxis());
        boundingOB.getzAxis().set(orientedBoundingBox.getZAxis());
        boundingOB.getExtent().set(orientedBoundingBox.getExtent());
        boundingOB.computeInformation();
        boundingOB.draw(renderer);
    }

    private static void drawBoundingCapsule(BoundingCapsule boundingCapsule, Renderer renderer) {
        Debugger.boundingCapsule.reconstruct(boundingCapsule.getLineSegment().getNegativeEnd(start), boundingCapsule.getLineSegment().getPositiveEnd(end), boundingCapsule.getRadius());
        Debugger.boundingCapsule.draw(renderer);
    }

    public static void drawNormals(SceneElement sceneElement, Renderer renderer) {
        Debugger.drawNormals(sceneElement, renderer, -1.0f, true);
    }

    public static void drawTangents(SceneElement sceneElement, Renderer renderer) {
        Debugger.drawTangents(sceneElement, renderer, -1.0f, true);
    }

    public static void drawNormals(SceneElement sceneElement, Renderer renderer, float f, boolean bl) {
        block20: {
            Object object;
            SceneElement sceneElement2;
            block19: {
                if (sceneElement == null) {
                    return;
                }
                if (normZState == null) {
                    normZState = renderer.createZBufferState();
                    normalLines.setRenderState(normZState);
                    normalLines.updateRenderState();
                }
                int n = renderer.getCamera().getPlaneState();
                if (sceneElement.getWorldBound() != null && renderer.getCamera().contains(sceneElement.getWorldBound()) == 0) {
                    renderer.getCamera().setPlaneState(n);
                    return;
                }
                renderer.getCamera().setPlaneState(n);
                if ((sceneElement.getType() & 0x100) != 0 && sceneElement.getCullMode() != 2) {
                    sceneElement2 = (GeomBatch)sceneElement;
                    float f2 = f;
                    if (f2 == -1.0f) {
                        object = sceneElement.getWorldBound();
                        if (object != null) {
                            measureBox.setCenter(((BoundingVolume)object).getCenter());
                            Debugger.measureBox.xExtent = 0.0f;
                            Debugger.measureBox.yExtent = 0.0f;
                            Debugger.measureBox.zExtent = 0.0f;
                            measureBox.mergeLocal((BoundingVolume)object);
                            f2 = AUTO_NORMAL_RATIO * ((Debugger.measureBox.xExtent + Debugger.measureBox.yExtent + Debugger.measureBox.zExtent) / 3.0f);
                        } else {
                            f2 = 1.0f;
                        }
                    }
                    object = ((GeomBatch)sceneElement2).getNormalBuffer();
                    FloatBuffer floatBuffer = ((GeomBatch)sceneElement2).getVertexBuffer();
                    if (object != null && floatBuffer != null && ((Buffer)object).limit() == floatBuffer.limit()) {
                        FloatBuffer floatBuffer2 = normalLines.getVertexBuffer(0);
                        if (floatBuffer2.capacity() < 3 * (2 * ((GeomBatch)sceneElement2).getVertexCount())) {
                            normalLines.setVertexBuffer(0, null);
                            System.gc();
                            floatBuffer2 = BufferUtils.createVector3Buffer(((GeomBatch)sceneElement2).getVertexCount() * 2);
                            normalLines.setVertexBuffer(0, floatBuffer2);
                        } else {
                            normalLines.getBatch(0).setVertexCount(2 * ((GeomBatch)sceneElement2).getVertexCount());
                            floatBuffer2.clear();
                        }
                        FloatBuffer floatBuffer3 = normalLines.getColorBuffer(0);
                        if (floatBuffer3.capacity() < 4 * (2 * ((GeomBatch)sceneElement2).getVertexCount())) {
                            normalLines.setColorBuffer(0, null);
                            System.gc();
                            floatBuffer3 = BufferUtils.createColorBuffer(((GeomBatch)sceneElement2).getVertexCount() * 2);
                            normalLines.setColorBuffer(0, floatBuffer3);
                        } else {
                            floatBuffer3.clear();
                        }
                        IntBuffer intBuffer = normalLines.getIndexBuffer();
                        if (intBuffer == null || intBuffer.capacity() < normalLines.getBatch(0).getVertexCount()) {
                            normalLines.setIndexBuffer(null);
                            System.gc();
                            intBuffer = BufferUtils.createIntBuffer(((GeomBatch)sceneElement2).getVertexCount() * 2);
                            normalLines.setIndexBuffer(intBuffer);
                        } else {
                            intBuffer.clear();
                            intBuffer.limit(normalLines.getBatch(0).getVertexCount());
                        }
                        floatBuffer.rewind();
                        ((FloatBuffer)object).rewind();
                        floatBuffer2.rewind();
                        intBuffer.rewind();
                        for (int i = 0; i < ((GeomBatch)sceneElement2).getVertexCount(); ++i) {
                            _normalVect.set(floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
                            _normalVect.multLocal(((GeomBatch)sceneElement2).getParentGeom().getWorldScale());
                            floatBuffer2.put(Debugger._normalVect.x);
                            floatBuffer2.put(Debugger._normalVect.y);
                            floatBuffer2.put(Debugger._normalVect.z);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_BASE.r);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_BASE.g);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_BASE.b);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_BASE.a);
                            intBuffer.put(i * 2);
                            _normalVect.addLocal(((FloatBuffer)object).get() * f2, ((FloatBuffer)object).get() * f2, ((FloatBuffer)object).get() * f2);
                            floatBuffer2.put(Debugger._normalVect.x);
                            floatBuffer2.put(Debugger._normalVect.y);
                            floatBuffer2.put(Debugger._normalVect.z);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_TIP.r);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_TIP.g);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_TIP.b);
                            floatBuffer3.put(Debugger.NORMAL_COLOR_TIP.a);
                            intBuffer.put(i * 2 + 1);
                        }
                        if (((GeomBatch)sceneElement2).getParentGeom() != null) {
                            normalLines.setLocalTranslation(((GeomBatch)sceneElement2).getParentGeom().getWorldTranslation());
                            normalLines.setLocalRotation(((GeomBatch)sceneElement2).getParentGeom().getWorldRotation());
                            normalLines.onDraw(renderer);
                        }
                    }
                }
                if (!bl || (sceneElement.getType() & 1) == 0) break block19;
                sceneElement2 = (Node)sceneElement;
                if (((Node)sceneElement2).getChildren() == null) break block20;
                int n2 = ((Node)sceneElement2).getChildren().size();
                while (--n2 >= 0) {
                    Debugger.drawNormals(((Node)sceneElement2).getChild(n2), renderer, f, true);
                }
                break block20;
            }
            if (bl && (sceneElement.getType() & 2) != 0 && ((Geometry)(sceneElement2 = (Geometry)sceneElement)).getBatchCount() > 0) {
                int n = ((Geometry)sceneElement2).getBatchCount();
                while (--n >= 0) {
                    object = ((Geometry)sceneElement2).getBatch(n);
                    if (!((GeomBatch)object).isEnabled()) continue;
                    Debugger.drawNormals((SceneElement)object, renderer, f, true);
                }
            }
        }
    }

    public static void drawTangents(SceneElement sceneElement, Renderer renderer, float f, boolean bl) {
        block20: {
            Object object;
            SceneElement sceneElement2;
            block19: {
                if (sceneElement == null) {
                    return;
                }
                if (normZState == null) {
                    normZState = renderer.createZBufferState();
                    normalLines.setRenderState(normZState);
                    normalLines.updateRenderState();
                }
                int n = renderer.getCamera().getPlaneState();
                if (sceneElement.getWorldBound() != null && renderer.getCamera().contains(sceneElement.getWorldBound()) == 0) {
                    renderer.getCamera().setPlaneState(n);
                    return;
                }
                renderer.getCamera().setPlaneState(n);
                if ((sceneElement.getType() & 0x100) != 0 && sceneElement.getCullMode() != 2) {
                    sceneElement2 = (GeomBatch)sceneElement;
                    float f2 = f;
                    if (f2 == -1.0f) {
                        object = sceneElement.getWorldBound();
                        if (object != null) {
                            measureBox.setCenter(((BoundingVolume)object).getCenter());
                            Debugger.measureBox.xExtent = 0.0f;
                            Debugger.measureBox.yExtent = 0.0f;
                            Debugger.measureBox.zExtent = 0.0f;
                            measureBox.mergeLocal((BoundingVolume)object);
                            f2 = AUTO_NORMAL_RATIO * ((Debugger.measureBox.xExtent + Debugger.measureBox.yExtent + Debugger.measureBox.zExtent) / 3.0f);
                        } else {
                            f2 = 1.0f;
                        }
                    }
                    object = ((GeomBatch)sceneElement2).getTangentBuffer();
                    FloatBuffer floatBuffer = ((GeomBatch)sceneElement2).getVertexBuffer();
                    if (object != null && floatBuffer != null && ((Buffer)object).limit() == floatBuffer.limit()) {
                        FloatBuffer floatBuffer2 = normalLines.getVertexBuffer(0);
                        if (floatBuffer2.capacity() < 3 * (2 * ((GeomBatch)sceneElement2).getVertexCount())) {
                            normalLines.setVertexBuffer(0, null);
                            System.gc();
                            floatBuffer2 = BufferUtils.createVector3Buffer(((GeomBatch)sceneElement2).getVertexCount() * 2);
                            normalLines.setVertexBuffer(0, floatBuffer2);
                        } else {
                            normalLines.getBatch(0).setVertexCount(2 * ((GeomBatch)sceneElement2).getVertexCount());
                            floatBuffer2.clear();
                        }
                        FloatBuffer floatBuffer3 = normalLines.getColorBuffer(0);
                        if (floatBuffer3.capacity() < 4 * (2 * ((GeomBatch)sceneElement2).getVertexCount())) {
                            normalLines.setColorBuffer(0, null);
                            System.gc();
                            floatBuffer3 = BufferUtils.createColorBuffer(((GeomBatch)sceneElement2).getVertexCount() * 2);
                            normalLines.setColorBuffer(0, floatBuffer3);
                        } else {
                            floatBuffer3.clear();
                        }
                        IntBuffer intBuffer = normalLines.getIndexBuffer();
                        if (intBuffer == null || intBuffer.capacity() < normalLines.getBatch(0).getVertexCount()) {
                            normalLines.setIndexBuffer(null);
                            System.gc();
                            intBuffer = BufferUtils.createIntBuffer(((GeomBatch)sceneElement2).getVertexCount() * 2);
                            normalLines.setIndexBuffer(intBuffer);
                        } else {
                            intBuffer.clear();
                            intBuffer.limit(normalLines.getBatch(0).getVertexCount());
                        }
                        floatBuffer.rewind();
                        ((FloatBuffer)object).rewind();
                        floatBuffer2.rewind();
                        intBuffer.rewind();
                        for (int i = 0; i < ((GeomBatch)sceneElement2).getVertexCount(); ++i) {
                            _normalVect.set(floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
                            _normalVect.multLocal(((GeomBatch)sceneElement2).getParentGeom().getWorldScale());
                            floatBuffer2.put(Debugger._normalVect.x);
                            floatBuffer2.put(Debugger._normalVect.y);
                            floatBuffer2.put(Debugger._normalVect.z);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.r);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.g);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.b);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.a);
                            intBuffer.put(i * 2);
                            _normalVect.addLocal(((FloatBuffer)object).get() * f2, ((FloatBuffer)object).get() * f2, ((FloatBuffer)object).get() * f2);
                            floatBuffer2.put(Debugger._normalVect.x);
                            floatBuffer2.put(Debugger._normalVect.y);
                            floatBuffer2.put(Debugger._normalVect.z);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.r);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.g);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.b);
                            floatBuffer3.put(Debugger.TANGENT_COLOR_BASE.a);
                            intBuffer.put(i * 2 + 1);
                        }
                        if (((GeomBatch)sceneElement2).getParentGeom() != null) {
                            normalLines.setLocalTranslation(((GeomBatch)sceneElement2).getParentGeom().getWorldTranslation());
                            normalLines.setLocalRotation(((GeomBatch)sceneElement2).getParentGeom().getWorldRotation());
                            normalLines.onDraw(renderer);
                        }
                    }
                }
                if (!bl || (sceneElement.getType() & 1) == 0) break block19;
                sceneElement2 = (Node)sceneElement;
                if (((Node)sceneElement2).getChildren() == null) break block20;
                int n2 = ((Node)sceneElement2).getChildren().size();
                while (--n2 >= 0) {
                    Debugger.drawTangents(((Node)sceneElement2).getChild(n2), renderer, f, true);
                }
                break block20;
            }
            if (bl && (sceneElement.getType() & 2) != 0 && ((Geometry)(sceneElement2 = (Geometry)sceneElement)).getBatchCount() > 0) {
                int n = ((Geometry)sceneElement2).getBatchCount();
                while (--n >= 0) {
                    object = ((Geometry)sceneElement2).getBatch(n);
                    if (!((GeomBatch)object).isEnabled()) continue;
                    Debugger.drawTangents((SceneElement)object, renderer, f, true);
                }
            }
        }
    }

    public static void drawBuffer(int n, int n2, Renderer renderer) {
        Debugger.drawBuffer(n, n2, renderer, (float)renderer.getWidth() / 6.25f);
    }

    public static void drawBuffer(int n, int n2, Renderer renderer, float f) {
        int n3;
        int n4;
        renderer.flush();
        float f2 = renderer.getWidth();
        float f3 = renderer.getHeight();
        bQuad.resize(f, (float)renderer.getHeight() / (float)renderer.getWidth() * f);
        if (bQuad.getRenderState(6) == null) {
            TextureState textureState = renderer.createTextureState();
            bufTexture = new Texture();
            textureState.setTexture(bufTexture);
            bQuad.setRenderState(textureState);
            bQuad.updateRenderState();
        }
        bufTexture.setRTTSource(n);
        if (bufTexRend == null) {
            bufTexRend = DisplaySystem.getDisplaySystem().createTextureRenderer(256, 256, 2);
            bufTexRend.setupTexture(bufTexture);
        }
        if (!FastMath.isPowerOfTwo(n4 = renderer.getWidth())) {
            n3 = 2;
            while ((n3 <<= 1) < n4) {
            }
            bQuad.getTextureBuffer(0, 0).put(4, (float)n4 / (float)n3);
            bQuad.getTextureBuffer(0, 0).put(6, (float)n4 / (float)n3);
            n4 = n3;
        }
        if (!FastMath.isPowerOfTwo(n3 = renderer.getHeight())) {
            int n5 = 2;
            while ((n5 <<= 1) < n3) {
            }
            bQuad.getTextureBuffer(0, 0).put(1, (float)n3 / (float)n5);
            bQuad.getTextureBuffer(0, 0).put(7, (float)n3 / (float)n5);
            n3 = n5;
        }
        bufTexRend.copyToTexture(bufTexture, n4, n3);
        float f4 = f * 0.75f;
        switch (n2) {
            case 0: {
                f2 = f4;
                f3 -= f4;
                break;
            }
            case 1: {
                f2 -= f4;
                f3 -= f4;
                break;
            }
            case 2: {
                f2 -= f4;
                f3 = f4;
                break;
            }
            default: {
                f2 = f4;
                f3 = f4;
            }
        }
        bQuad.getWorldTranslation().set(f2, f3, 0.0f);
        bQuad.onDraw(renderer);
        renderer.flush();
    }

    static {
        boundingSphere.setRenderQueueMode(1);
        boundingBox = new Box("bbox", new Vector3f(), 1.0f, 1.0f, 1.0f);
        boundingBox.setRenderQueueMode(1);
        boundingOB = new OrientedBox("bobox");
        boundingOB.setRenderQueueMode(1);
        boundingCapsule = new Capsule("bcap", 3, 10, 10, 1.0f, 1.0f);
        boundingCapsule.setRenderQueueMode(1);
        start = new Vector3f();
        end = new Vector3f();
        normalLines = new Line("normLine");
        normalLines.setLineWidth(3.0f);
        normalLines.setMode(0);
        normalLines.setVertexBuffer(0, BufferUtils.createVector3Buffer(500));
        normalLines.setColorBuffer(0, BufferUtils.createColorBuffer(500));
        _normalVect = new Vector3f();
        NORMAL_COLOR_BASE = ColorRGBA.red.clone();
        NORMAL_COLOR_TIP = ColorRGBA.pink.clone();
        TANGENT_COLOR_BASE = ColorRGBA.red.clone();
        measureBox = new BoundingBox();
        AUTO_NORMAL_RATIO = 0.05f;
        bQuad = new Quad("", 128.0f, 128.0f);
        bQuad.setRenderQueueMode(4);
        bQuad.setCullMode(3);
    }
}

