/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;

class VertexData
implements Comparable {
    public int smoothGroup = -1;
    public Vector3f coord = null;
    public Vector3f normal = null;
    public ColorRGBA color4 = null;
    public Vector2f[] texCoords = null;

    public VertexData() {
    }

    public VertexData(VertexData vertexData) {
        this.smoothGroup = vertexData.smoothGroup;
        if (vertexData.coord != null) {
            this.coord = new Vector3f(vertexData.coord);
        }
        if (vertexData.normal != null) {
            this.normal = new Vector3f(vertexData.normal);
        }
        if (vertexData.color4 != null) {
            this.color4 = new ColorRGBA(vertexData.color4);
        }
        if (vertexData.texCoords != null) {
            this.texCoords = new Vector2f[vertexData.texCoords.length];
            for (int i = 0; i < this.texCoords.length; ++i) {
                this.texCoords[i] = vertexData.texCoords[i] == null ? null : new Vector2f(vertexData.texCoords[i]);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.coord != null) {
            stringBuffer.append("P").append(this.coord);
        }
        if (this.normal != null) {
            stringBuffer.append("N").append(this.normal);
        }
        if (this.color4 != null) {
            stringBuffer.append("C").append(this.color4);
        }
        for (int i = 0; this.texCoords != null && i < this.texCoords.length; ++i) {
            stringBuffer.append("T").append(this.texCoords[i]);
        }
        if (this.smoothGroup >= 0) {
            stringBuffer.append("S").append(this.smoothGroup);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        if (this.coord != null) {
            n ^= this.coord.hashCode();
        }
        if (this.normal != null) {
            n ^= this.normal.hashCode();
        }
        if (this.color4 != null) {
            n ^= this.color4.hashCode();
        }
        return n;
    }

    public int compareTo(Object object) {
        VertexData vertexData = (VertexData)object;
        int n = this.compare(this.coord, vertexData.coord);
        if (n != 0) {
            return n;
        }
        n = this.compare(this.normal, vertexData.normal);
        if (n != 0) {
            return n;
        }
        n = this.compare(this.color4, vertexData.color4);
        if (n != 0) {
            return n;
        }
        n = this.compare(this.texCoords, vertexData.texCoords);
        if (n != 0) {
            return n;
        }
        n = this.smoothGroup - vertexData.smoothGroup;
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        VertexData vertexData = (VertexData)object;
        return VertexData.isEqual(this.coord, vertexData.coord) && VertexData.isEqual(this.normal, vertexData.normal) && VertexData.isEqual(this.color4, vertexData.color4) && VertexData.isEqual(this.texCoords, vertexData.texCoords) && this.smoothGroup == vertexData.smoothGroup;
    }

    private static int fdiff(float f) {
        if (f < 0.0f) {
            return -1;
        }
        if (f > 0.0f) {
            return 1;
        }
        return 0;
    }

    private int compare(Vector2f vector2f, Vector2f vector2f2) {
        if (vector2f == null && vector2f2 == null) {
            return 0;
        }
        if (vector2f == null) {
            return -1;
        }
        if (vector2f2 == null) {
            return 1;
        }
        float f = vector2f.x - vector2f2.x;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        f = vector2f.y - vector2f2.y;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        return 0;
    }

    private int compare(Vector2f[] vector2fArray, Vector2f[] vector2fArray2) {
        if (vector2fArray == null && vector2fArray2 == null) {
            return 0;
        }
        if (vector2fArray == null) {
            return -1;
        }
        if (vector2fArray2 == null) {
            return 1;
        }
        if (vector2fArray.length != vector2fArray2.length) {
            return vector2fArray.length - vector2fArray2.length;
        }
        for (int i = 0; i < vector2fArray.length; ++i) {
            int n = this.compare(vector2fArray[i], vector2fArray2[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private int compare(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f == null && vector3f2 == null) {
            return 0;
        }
        if (vector3f == null) {
            return -1;
        }
        if (vector3f2 == null) {
            return 1;
        }
        float f = vector3f.x - vector3f2.x;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        f = vector3f.y - vector3f2.y;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        f = vector3f.z - vector3f2.z;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        return 0;
    }

    private int compare(ColorRGBA colorRGBA, ColorRGBA colorRGBA2) {
        if (colorRGBA == null && colorRGBA2 == null) {
            return 0;
        }
        if (colorRGBA == null) {
            return -1;
        }
        if (colorRGBA2 == null) {
            return 1;
        }
        float f = colorRGBA.r - colorRGBA2.r;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        f = colorRGBA.g - colorRGBA2.g;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        f = colorRGBA.b - colorRGBA2.b;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        f = colorRGBA.a - colorRGBA2.a;
        if (f != 0.0f) {
            return VertexData.fdiff(f);
        }
        return 0;
    }

    private static boolean isEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private static boolean isEqual(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (VertexData.isEqual(objectArray[i], objectArray2[i])) continue;
            return false;
        }
        return true;
    }
}

