/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom.nvtristrip;

import com.jme.util.geom.nvtristrip.EdgeInfo;
import com.jme.util.geom.nvtristrip.EdgeInfoVec;
import com.jme.util.geom.nvtristrip.FaceInfo;
import com.jme.util.geom.nvtristrip.FaceInfoVec;
import com.jme.util.geom.nvtristrip.IntVec;
import com.jme.util.geom.nvtristrip.StripStartInfo;
import com.jme.util.geom.nvtristrip.Stripifier;

class StripInfo {
    StripStartInfo m_startInfo;
    FaceInfoVec m_faces = new FaceInfoVec();
    int m_stripId;
    int m_experimentId;
    boolean visited;
    int m_numDegenerates;

    public StripInfo(StripStartInfo stripStartInfo, int n, int n2) {
        this.m_startInfo = stripStartInfo;
        this.m_stripId = n;
        this.m_experimentId = n2;
        this.visited = false;
        this.m_numDegenerates = 0;
    }

    boolean isExperiment() {
        return this.m_experimentId >= 0;
    }

    boolean isInStrip(FaceInfo faceInfo) {
        if (faceInfo == null) {
            return false;
        }
        return this.m_experimentId >= 0 ? faceInfo.m_testStripId == this.m_stripId : faceInfo.m_stripId == this.m_stripId;
    }

    boolean isMarked(FaceInfo faceInfo) {
        return faceInfo.m_stripId >= 0 || this.isExperiment() && faceInfo.m_experimentId == this.m_experimentId;
    }

    void markTriangle(FaceInfo faceInfo) {
        if (this.isExperiment()) {
            faceInfo.m_experimentId = this.m_experimentId;
            faceInfo.m_testStripId = this.m_stripId;
        } else {
            faceInfo.m_experimentId = -1;
            faceInfo.m_stripId = this.m_stripId;
        }
    }

    boolean unique(FaceInfoVec faceInfoVec, FaceInfo faceInfo) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < faceInfoVec.size(); ++i) {
            if (!(bl3 || faceInfoVec.at((int)i).m_v0 != faceInfo.m_v0 && faceInfoVec.at((int)i).m_v1 != faceInfo.m_v0 && faceInfoVec.at((int)i).m_v2 != faceInfo.m_v0)) {
                bl3 = true;
            }
            if (!(bl2 || faceInfoVec.at((int)i).m_v0 != faceInfo.m_v1 && faceInfoVec.at((int)i).m_v1 != faceInfo.m_v1 && faceInfoVec.at((int)i).m_v2 != faceInfo.m_v1)) {
                bl2 = true;
            }
            if (!(bl || faceInfoVec.at((int)i).m_v0 != faceInfo.m_v2 && faceInfoVec.at((int)i).m_v1 != faceInfo.m_v2 && faceInfoVec.at((int)i).m_v2 != faceInfo.m_v2)) {
                bl = true;
            }
            if (!bl3 || !bl2 || !bl) continue;
            return false;
        }
        return true;
    }

    void build(EdgeInfoVec edgeInfoVec, FaceInfoVec faceInfoVec) {
        FaceInfo faceInfo;
        FaceInfo faceInfo2;
        int n;
        IntVec intVec = new IntVec();
        FaceInfoVec faceInfoVec2 = new FaceInfoVec();
        FaceInfoVec faceInfoVec3 = new FaceInfoVec();
        faceInfoVec2.add(this.m_startInfo.m_startFace);
        this.markTriangle(this.m_startInfo.m_startFace);
        int n2 = this.m_startInfo.m_toV1 ? this.m_startInfo.m_startEdge.m_v0 : this.m_startInfo.m_startEdge.m_v1;
        int n3 = this.m_startInfo.m_toV1 ? this.m_startInfo.m_startEdge.m_v1 : this.m_startInfo.m_startEdge.m_v0;
        intVec.add(n2);
        intVec.add(n3);
        int n4 = Stripifier.getNextIndex(intVec, this.m_startInfo.m_startFace);
        intVec.add(n4);
        int n5 = n3;
        int n6 = n4;
        FaceInfo faceInfo3 = Stripifier.findOtherFace(edgeInfoVec, n5, n6, this.m_startInfo.m_startFace);
        while (faceInfo3 != null && !this.isMarked(faceInfo3)) {
            int n7 = n6;
            n = Stripifier.getNextIndex(intVec, faceInfo3);
            FaceInfo faceInfo4 = Stripifier.findOtherFace(edgeInfoVec, n7, n, faceInfo3);
            if ((faceInfo4 == null || this.isMarked(faceInfo4)) && (faceInfo2 = Stripifier.findOtherFace(edgeInfoVec, n5, n, faceInfo3)) != null && !this.isMarked(faceInfo2)) {
                faceInfo = new FaceInfo(n5, n6, n5);
                faceInfoVec2.add(faceInfo);
                this.markTriangle(faceInfo);
                intVec.add(n5);
                n7 = n5;
                ++this.m_numDegenerates;
            }
            faceInfoVec2.add(faceInfo3);
            this.markTriangle(faceInfo3);
            intVec.add(n);
            n5 = n7;
            n6 = n;
            faceInfo3 = Stripifier.findOtherFace(edgeInfoVec, n5, n6, faceInfo3);
        }
        FaceInfoVec faceInfoVec4 = new FaceInfoVec();
        for (n = 0; n < faceInfoVec2.size(); ++n) {
            faceInfoVec4.add(faceInfoVec2.at(n));
        }
        intVec.clear();
        intVec.add(n4);
        intVec.add(n3);
        intVec.add(n2);
        n5 = n3;
        n6 = n2;
        faceInfo3 = Stripifier.findOtherFace(edgeInfoVec, n5, n6, this.m_startInfo.m_startFace);
        while (faceInfo3 != null && !this.isMarked(faceInfo3) && this.unique(faceInfoVec4, faceInfo3)) {
            n = n6;
            int n8 = Stripifier.getNextIndex(intVec, faceInfo3);
            faceInfo2 = Stripifier.findOtherFace(edgeInfoVec, n, n8, faceInfo3);
            if ((faceInfo2 == null || this.isMarked(faceInfo2)) && (faceInfo = Stripifier.findOtherFace(edgeInfoVec, n5, n8, faceInfo3)) != null && !this.isMarked(faceInfo)) {
                FaceInfo faceInfo5 = new FaceInfo(n5, n6, n5);
                faceInfoVec3.add(faceInfo5);
                this.markTriangle(faceInfo5);
                intVec.add(n5);
                n = n5;
                ++this.m_numDegenerates;
            }
            faceInfoVec3.add(faceInfo3);
            faceInfoVec4.add(faceInfo3);
            this.markTriangle(faceInfo3);
            intVec.add(n8);
            n5 = n;
            n6 = n8;
            faceInfo3 = Stripifier.findOtherFace(edgeInfoVec, n5, n6, faceInfo3);
        }
        this.combine(faceInfoVec2, faceInfoVec3);
    }

    void combine(FaceInfoVec faceInfoVec, FaceInfoVec faceInfoVec2) {
        int n;
        int n2 = faceInfoVec2.size();
        for (n = n2 - 1; n >= 0; --n) {
            this.m_faces.add(faceInfoVec2.at(n));
        }
        n2 = faceInfoVec.size();
        for (n = 0; n < n2; ++n) {
            this.m_faces.add(faceInfoVec.at(n));
        }
    }

    boolean sharesEdge(FaceInfo faceInfo, EdgeInfoVec edgeInfoVec) {
        EdgeInfo edgeInfo = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v0, faceInfo.m_v1);
        if (this.isInStrip(edgeInfo.m_face0) || this.isInStrip(edgeInfo.m_face1)) {
            return true;
        }
        edgeInfo = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v1, faceInfo.m_v2);
        if (this.isInStrip(edgeInfo.m_face0) || this.isInStrip(edgeInfo.m_face1)) {
            return true;
        }
        edgeInfo = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v2, faceInfo.m_v0);
        return this.isInStrip(edgeInfo.m_face0) || this.isInStrip(edgeInfo.m_face1);
    }
}

