/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.swingui;

import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.util.geom.BufferUtils;
import com.jmex.awt.swingui.ImageGraphics;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;
import org.lwjgl.opengl.glu.GLU;

class LWJGLImageGraphics
extends ImageGraphics {
    private static final Logger logger = Logger.getLogger(LWJGLImageGraphics.class.getName());
    private final BufferedImage awtImage;
    private final Graphics2D delegate;
    private final byte[] data;
    private final Rectangle dirty;
    private final Point translation = new Point();
    private ByteBuffer tmp_byteBuffer;
    private final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private final int paintedMipMapCount;
    private int mipMapLevel = 0;
    private LWJGLImageGraphics mipMapChild;
    private boolean glTexSubImage2DSupported = true;
    private IntBuffer idBuff = BufferUtils.createIntBuffer((int)16);
    private Rectangle imageBounds;
    private Rectangle clip = new Rectangle();
    private Rectangle tmp_dirty = new Rectangle();
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;

    private LWJGLImageGraphics(BufferedImage bufferedImage, byte[] byArray, Graphics2D graphics2D, com.jme.image.Image image, Rectangle rectangle, int n, int n2, float f, float f2, int n3, LWJGLImageGraphics lWJGLImageGraphics, int n4) {
        super(image);
        this.awtImage = bufferedImage;
        this.data = byArray;
        this.delegate = graphics2D;
        this.dirty = rectangle;
        this.translation.x = n;
        this.translation.y = n2;
        this.scaleX = f;
        this.scaleY = f2;
        this.paintedMipMapCount = n3;
        this.mipMapChild = lWJGLImageGraphics;
        this.mipMapLevel = n4;
    }

    protected LWJGLImageGraphics(int n, int n2, int n3) {
        this(n, n2, n3, 0, 1.0f);
    }

    private LWJGLImageGraphics(int n, int n2, int n3, int n4, float f) {
        super(new com.jme.image.Image());
        if (!(n3 <= 1 || FastMath.isPowerOfTwo((int)n) && FastMath.isPowerOfTwo((int)n2))) {
            throw new IllegalArgumentException("Size must be power of 2 if mipmaps should be generated");
        }
        this.awtImage = new BufferedImage(n, n2, 6);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * n * n2));
        this.tmp_byteBuffer = BufferUtils.createByteBuffer((int)(4 * n * n2));
        this.data = (byte[])this.awtImage.getRaster().getDataElements(0, 0, this.awtImage.getWidth(), this.awtImage.getHeight(), null);
        byteBuffer.clear();
        byteBuffer.put(this.data);
        byteBuffer.flip();
        this.image.setType(3);
        this.image.setWidth(n);
        this.image.setHeight(n2);
        this.image.setData(byteBuffer);
        this.delegate = (Graphics2D)this.awtImage.getGraphics();
        this.dirty = new Rectangle(0, 0, n, n2);
        this.mipMapLevel = n4;
        this.scale(f, f);
        this.paintedMipMapCount = n3;
        if (n3 > 0 && (n > 1 || n2 > 1)) {
            if (n < 2) {
                n = 2;
            }
            if (n2 < 2) {
                n2 = 2;
            }
            this.mipMapChild = new LWJGLImageGraphics(n / 2, n2 / 2, n3, n4 + 1, f * 0.5f);
        }
        this.setBackground(this.TRANSPARENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Texture texture, boolean bl) {
        int n;
        int n2;
        boolean bl2 = false;
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            if (!this.dirty.isEmpty()) {
                this.dirty.grow(2, 2);
            }
            Rectangle2D.intersect(this.dirty, this.getImageBounds(), this.dirty);
            if (!this.dirty.isEmpty()) {
                ByteBuffer byteBuffer;
                try {
                    Util.checkGLError();
                }
                catch (OpenGLException openGLException) {
                    throw new RuntimeException("OpenGLException caused before any GL commands by LWJGLImageGraphics!", openGLException);
                }
                this.idBuff.clear();
                GL11.glGetInteger((int)32873, (IntBuffer)this.idBuff);
                n2 = this.idBuff.get();
                GL11.glBindTexture((int)3553, (int)texture.getTextureId());
                GL11.glPixelStorei((int)3317, (int)1);
                int n3 = n = texture.getMipmap() > 2 ? 1 : 0;
                if (!this.glTexSubImage2DSupported || n != 0 && this.paintedMipMapCount == 0) {
                    this.update();
                    byteBuffer = this.image.getData();
                    byteBuffer.rewind();
                    if (n == 0) {
                        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.getImage().getWidth(), (int)this.getImage().getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                    } else {
                        GLU.gluBuild2DMipmaps((int)3553, (int)32856, (int)this.image.getWidth(), (int)this.image.getHeight(), (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                    }
                    Util.checkGLError();
                } else {
                    this.awtImage.getRaster().getDataElements(this.dirty.x, this.dirty.y, this.dirty.width, this.dirty.height, this.data);
                    byteBuffer = this.tmp_byteBuffer;
                    byteBuffer.clear();
                    byteBuffer.put(this.data);
                    byteBuffer.flip();
                    GL11.glTexSubImage2D((int)3553, (int)this.mipMapLevel, (int)this.dirty.x, (int)this.dirty.y, (int)this.dirty.width, (int)this.dirty.height, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                    try {
                        Util.checkGLError();
                    }
                    catch (OpenGLException openGLException) {
                        logger.warning("Error updating dirty region: " + this.dirty + " - " + "falling back to updating whole image!");
                        this.glTexSubImage2DSupported = false;
                        this.update(texture, bl);
                    }
                    bl2 = this.mipMapChild != null;
                }
                GL11.glBindTexture((int)3553, (int)n2);
            }
        }
        if (bl2) {
            this.dirty.x &= 0xFFFFFFFE;
            this.dirty.y &= 0xFFFFFFFE;
            if ((this.dirty.width & 1) != 0) {
                ++this.dirty.width;
            }
            if ((this.dirty.height & 1) != 0) {
                ++this.dirty.height;
            }
            int n4 = (int)((float)(this.dirty.x - this.translation.x) / this.scaleX);
            n2 = (int)((float)(this.dirty.y - this.translation.y) / this.scaleY);
            n = (int)((float)(this.dirty.x + this.dirty.width - this.translation.x) / this.scaleX);
            int n5 = (int)((float)(this.dirty.y + this.dirty.height - this.translation.y) / this.scaleY);
            int n6 = n - n4;
            int n7 = n5 - n2;
            this.mipMapChild.setClip(n4, n2, n6, n7);
            this.mipMapChild.delegate.clearRect(n4, n2, n6, n7);
            this.mipMapChild.delegate.drawImage(this.awtImage, n4, n2, n, n5, this.dirty.x, this.dirty.y, this.dirty.x + this.dirty.width, this.dirty.y + this.dirty.height, null);
            this.mipMapChild.makeDirty(n4, n2, n6, n7);
            this.mipMapChild.update(texture, bl);
        }
        if (bl) {
            this.dirty.width = 0;
        }
    }

    private Rectangle getImageBounds() {
        if (this.imageBounds == null) {
            this.imageBounds = new Rectangle(0, 0, this.getImage().getWidth(), this.getImage().getHeight());
        }
        return this.imageBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.awtImage.getRaster().getDataElements(0, 0, this.awtImage.getWidth(), this.awtImage.getHeight(), this.data);
            ByteBuffer byteBuffer = this.getImage().getData();
            byteBuffer.clear();
            byteBuffer.put(this.data);
            byteBuffer.flip();
        }
    }

    public boolean isDirty() {
        return !this.dirty.isEmpty();
    }

    private void makeDirty(int n, int n2, int n3, int n4) {
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        this.tmp_dirty.setBounds(n, n2, n3, n4);
        this.makeDirty(this.tmp_dirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDirty(Rectangle rectangle) {
        Rectangle rectangle2 = this.dirty;
        synchronized (rectangle2) {
            this.getClipBounds(this.clip);
            Rectangle2D.intersect(this.clip, rectangle, rectangle);
            if (!rectangle.isEmpty()) {
                rectangle.x = (int)((float)rectangle.x * this.scaleX);
                rectangle.y = (int)((float)rectangle.y * this.scaleY);
                rectangle.width = (int)((float)rectangle.width * this.scaleX);
                rectangle.height = (int)((float)rectangle.height * this.scaleY);
                rectangle.translate(this.translation.x, this.translation.y);
                Rectangle2D.intersect(rectangle, this.getImageBounds(), rectangle);
                if (!rectangle.isEmpty()) {
                    if (!this.dirty.isEmpty()) {
                        this.dirty.add(rectangle);
                    } else {
                        this.dirty.setBounds(rectangle);
                    }
                }
            }
        }
    }

    private void makeDirty() {
        this.makeDirty(0, 0, this.getImage().getWidth(), this.getImage().getHeight());
    }

    public Graphics create() {
        return new LWJGLImageGraphics(this.awtImage, this.data, (Graphics2D)this.delegate.create(), this.image, this.dirty, this.translation.x, this.translation.y, this.scaleX, this.scaleY, this.paintedMipMapCount, this.mipMapChild != null && this.mipMapLevel < this.paintedMipMapCount - 1 ? (LWJGLImageGraphics)this.mipMapChild.create() : null, this.mipMapLevel);
    }

    public Color getColor() {
        return this.delegate.getColor();
    }

    public void setColor(Color color) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setColor(color);
        }
        this.delegate.setColor(color);
    }

    public void setPaintMode() {
        if (this.mipMapChild != null) {
            this.mipMapChild.setPaintMode();
        }
        this.delegate.setPaintMode();
    }

    public void setXORMode(Color color) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setXORMode(color);
        }
        this.delegate.setXORMode(color);
    }

    public Font getFont() {
        return this.delegate.getFont();
    }

    public void setFont(Font font) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setFont(font);
        }
        this.delegate.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.delegate.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.delegate.getClipBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        if (this.mipMapChild != null) {
            this.mipMapChild.clipRect(n, n2, n3, n4);
        }
        this.delegate.clipRect(n, n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setClip(n, n2, n3, n4);
        }
        this.delegate.setClip(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.delegate.getClip();
    }

    public void setClip(Shape shape) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setClip(shape);
        }
        this.delegate.setClip(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mipMapChild != null) {
            this.mipMapChild.copyArea(n, n2, n3, n4, n5, n6);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n + n5, n2 + n6, n3, n4);
            this.delegate.copyArea(n, n2, n3, n4, n5, n6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawLine(n, n2, n3, n4);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3 - n, n4 - n2);
            this.delegate.drawLine(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(int n, int n2, int n3, int n4) {
        if (this.mipMapChild != null) {
            this.mipMapChild.fillRect(n, n2, n3, n4);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            this.delegate.fillRect(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.mipMapChild != null) {
            this.mipMapChild.clearRect(n, n2, n3, n4);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            Color color = this.delegate.getColor();
            this.delegate.setColor(this.TRANSPARENT);
            Composite composite = this.delegate.getComposite();
            this.delegate.setComposite(AlphaComposite.Clear);
            this.delegate.fillRect(n, n2, n3, n4);
            this.delegate.setComposite(composite);
            this.delegate.setColor(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawRoundRect(n, n2, n3, n4, n5, n6);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            this.delegate.drawRoundRect(n, n2, n3, n4, n5, n6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mipMapChild != null) {
            this.mipMapChild.fillRoundRect(n, n2, n3, n4, n5, n6);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            this.delegate.fillRoundRect(n, n2, n3, n4, n5, n6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(int n, int n2, int n3, int n4) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawOval(n, n2, n3, n4);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            this.delegate.drawOval(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOval(int n, int n2, int n3, int n4) {
        if (this.mipMapChild != null) {
            this.mipMapChild.fillOval(n, n2, n3, n4);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            this.delegate.fillOval(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawArc(n, n2, n3, n4, n5, n6);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            this.delegate.drawArc(n, n2, n3, n4, n5, n6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.mipMapChild != null) {
            this.mipMapChild.fillArc(n, n2, n3, n4, n5, n6);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            this.delegate.fillArc(n, n2, n3, n4, n5, n6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawPolyline(nArray, nArray2, n);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawPolyline(nArray, nArray2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawPolygon(nArray, nArray2, n);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawPolygon(nArray, nArray2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.mipMapChild != null) {
            this.mipMapChild.fillPolygon(nArray, nArray2, n);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.fillPolygon(nArray, nArray2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.makeDirty(n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver));
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            if (this.mipMapChild != null) {
                this.mipMapChild.drawImage(image, n, n2, imageObserver);
            }
            return this.delegate.drawImage(image, n, n2, imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawImage(image, n, n2, n3, n4, imageObserver);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            return this.delegate.drawImage(image, n, n2, n3, n4, imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawImage(image, n, n2, color, imageObserver);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver));
            return this.delegate.drawImage(image, n, n2, color, imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawImage(image, n, n2, n3, n4, color, imageObserver);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3, n4);
            return this.delegate.drawImage(image, n, n2, n3, n4, color, imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3 - n, n4 - n2);
            return this.delegate.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, n3 - n, n4 - n2);
            return this.delegate.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
    }

    public void dispose() {
        if (this.mipMapChild != null) {
            this.mipMapChild.dispose();
        }
        this.delegate.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Shape shape) {
        if (this.mipMapChild != null) {
            this.mipMapChild.draw(shape);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(shape.getBounds());
            this.delegate.draw(shape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawImage(image, affineTransform, imageObserver);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            return this.delegate.drawImage(image, affineTransform, imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawImage(bufferedImage, bufferedImageOp, n, n2);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(n, n2, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
            this.delegate.drawImage(bufferedImage, bufferedImageOp, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawRenderedImage(renderedImage, affineTransform);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawRenderedImage(renderedImage, affineTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawRenderableImage(renderableImage, affineTransform);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawRenderableImage(renderableImage, affineTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(String string, int n, int n2) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawString(string, n, n2);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawString(string, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(String string, float f, float f2) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawString(string, f, f2);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawString(string, f, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawString(attributedCharacterIterator, n, n2);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawString(attributedCharacterIterator, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawString(attributedCharacterIterator, f, f2);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawString(attributedCharacterIterator, f, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (this.mipMapChild != null) {
            this.mipMapChild.drawGlyphVector(glyphVector, f, f2);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty();
            this.delegate.drawGlyphVector(glyphVector, f, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(Shape shape) {
        if (this.mipMapChild != null) {
            this.mipMapChild.fill(shape);
        }
        Rectangle rectangle = this.dirty;
        synchronized (rectangle) {
            this.makeDirty(shape.getBounds());
            this.delegate.fill(shape);
        }
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.delegate.hit(rectangle, shape, bl);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.delegate.getDeviceConfiguration();
    }

    public void setComposite(Composite composite) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setComposite(composite);
        }
        this.delegate.setComposite(composite);
    }

    public void setPaint(Paint paint) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setPaint(paint);
        }
        this.delegate.setPaint(paint);
    }

    public void setStroke(Stroke stroke) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setStroke(stroke);
        }
        this.delegate.setStroke(stroke);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setRenderingHint(key, object);
        }
        this.delegate.setRenderingHint(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.delegate.getRenderingHint(key);
    }

    public void setRenderingHints(Map map) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setRenderingHints(map);
        }
        this.delegate.setRenderingHints(map);
    }

    public void addRenderingHints(Map map) {
        if (this.mipMapChild != null) {
            this.mipMapChild.addRenderingHints(map);
        }
        this.delegate.addRenderingHints(map);
    }

    public RenderingHints getRenderingHints() {
        return this.delegate.getRenderingHints();
    }

    public void translate(int n, int n2) {
        this.translation.x = (int)((float)this.translation.x + (float)n * this.scaleX);
        this.translation.y = (int)((float)this.translation.y + (float)n2 * this.scaleY);
        if (this.mipMapChild != null) {
            this.mipMapChild.translate(n, n2);
        }
        this.delegate.translate(n, n2);
    }

    public void translate(double d, double d2) {
        this.translation.x = (int)((double)this.translation.x + d * (double)this.scaleX);
        this.translation.y = (int)((double)this.translation.y + d2 * (double)this.scaleY);
        if (this.mipMapChild != null) {
            this.mipMapChild.translate(d, d2);
        }
        this.delegate.translate(d, d2);
    }

    public void rotate(double d) {
        throw new UnsupportedOperationException();
    }

    public void rotate(double d, double d2, double d3) {
        throw new UnsupportedOperationException();
    }

    public void scale(double d, double d2) {
        this.scaleX = (float)((double)this.scaleX * d);
        this.scaleY = (float)((double)this.scaleY * d2);
        if (this.mipMapChild != null) {
            this.mipMapChild.scale(d, d2);
        }
        this.delegate.scale(d, d2);
    }

    public void shear(double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public void transform(AffineTransform affineTransform) {
        throw new UnsupportedOperationException();
    }

    public void setTransform(AffineTransform affineTransform) {
        throw new UnsupportedOperationException();
    }

    public AffineTransform getTransform() {
        return this.delegate.getTransform();
    }

    public Paint getPaint() {
        return this.delegate.getPaint();
    }

    public Composite getComposite() {
        return this.delegate.getComposite();
    }

    public void setBackground(Color color) {
        if (this.mipMapChild != null) {
            this.mipMapChild.setBackground(color);
        }
        this.delegate.setBackground(color);
    }

    public Color getBackground() {
        return this.delegate.getBackground();
    }

    public Stroke getStroke() {
        return this.delegate.getStroke();
    }

    public void clip(Shape shape) {
        if (this.mipMapChild != null) {
            this.mipMapChild.clip(shape);
        }
        this.delegate.clip(shape);
    }

    public FontRenderContext getFontRenderContext() {
        return this.delegate.getFontRenderContext();
    }
}

