/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import jp.sourceforge.mmosf.server.FatalIOError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PacketCache {
    private static Log log = LogFactory.getLog(PacketCache.class);
    protected static final int BUFF_SIZE = 20480;
    protected static final int INT_SIZE = 4;
    protected LinkedList<ByteBuffer> listData = new LinkedList();
    protected int buffSize = -1;
    protected ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
    protected ByteBuffer dataBuffer = null;

    public void put(InputStream is) throws IOException {
        try {
            int length = is.available();
            int pos = 0;
            while (pos < length) {
                if (this.buffSize == -1) {
                    int rlen = this.read(this.sizeBuffer, is);
                    if (rlen <= 0) break;
                    pos += rlen;
                    if (this.sizeBuffer.remaining() == 0) {
                        this.sizeBuffer.position(0);
                        this.buffSize = this.sizeBuffer.getInt();
                    }
                } else {
                    int rlen2;
                    if (this.dataBuffer == null) {
                        if (this.buffSize > 20480) {
                            FatalIOError error = new FatalIOError("too long packet size.");
                            error.fillInStackTrace();
                            throw error;
                        }
                        this.dataBuffer = ByteBuffer.allocate(this.buffSize);
                    }
                    if ((rlen2 = this.read(this.dataBuffer, is)) <= 0) break;
                    pos += rlen2;
                }
                if (this.dataBuffer == null || this.dataBuffer.remaining() != 0) continue;
                if (this.listData.size() > 30) {
                    FatalIOError exception = new FatalIOError("full buffer.");
                    exception.fillInStackTrace();
                    throw exception;
                }
                this.listData.addLast(this.dataBuffer);
                this.dataBuffer = null;
                this.buffSize = -1;
                this.sizeBuffer.position(0);
            }
        }
        catch (SocketTimeoutException e) {
            FatalIOError exception = new FatalIOError("timeout in read, ", e);
            exception.fillInStackTrace();
            throw exception;
        }
    }

    public void put(ReadableByteChannel cannel) throws IOException {
        block6: {
            int pos = 0;
            do {
                int rlen2;
                if (this.buffSize == -1) {
                    int rlen = cannel.read(this.sizeBuffer);
                    if (rlen > 0) {
                        pos += rlen;
                        if (this.sizeBuffer.remaining() != 0) continue;
                        if (log.isTraceEnabled()) {
                            log.trace(PacketCache.toString(this.sizeBuffer.array()));
                        }
                        this.sizeBuffer.position(0);
                        this.buffSize = this.sizeBuffer.getInt();
                        continue;
                    }
                    break block6;
                }
                if (this.dataBuffer == null) {
                    this.dataBuffer = ByteBuffer.allocate(this.buffSize);
                }
                if ((rlen2 = cannel.read(this.dataBuffer)) <= 0) break block6;
                pos += rlen2;
            } while (this.dataBuffer == null || this.dataBuffer.remaining() != 0);
            if (log.isTraceEnabled()) {
                log.trace(PacketCache.toString(this.dataBuffer.array()));
            }
            this.listData.addLast(this.dataBuffer);
            this.dataBuffer = null;
            this.buffSize = -1;
            this.sizeBuffer.position(0);
        }
    }

    protected int read(ByteBuffer bytebuff, InputStream is) throws IOException {
        int rlen = 0;
        if (bytebuff.remaining() > 0) {
            byte[] buff = new byte[bytebuff.capacity()];
            rlen = is.read(buff, 0, bytebuff.remaining());
            if (rlen <= 0) {
                return rlen;
            }
            bytebuff.put(buff, 0, rlen);
        }
        return rlen;
    }

    public boolean isGet() {
        return this.listData.size() > 0;
    }

    public ByteBuffer get() {
        if (this.listData.size() == 0) {
            return null;
        }
        ByteBuffer buff = this.listData.getFirst();
        this.listData.removeFirst();
        buff.position(0);
        return buff;
    }

    private static String toString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            sb.append("[");
            sb.append(b[i]);
            sb.append("] ");
            ++i;
        }
        return sb.toString();
    }
}

