/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.server.PacketCache;
import jp.sourceforge.mmosf.server.SocketManager;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserConnection {
    protected static final int TIME_LIMIT = 30000;
    private static final Log log = LogFactory.getLog(UserConnection.class);
    static final int BUFF_SIZE = 4096;
    protected String connectID;
    protected SocketManager sockManager = null;
    protected PacketCache cacheReceive = null;
    protected List<ByteBuffer> cacheSend = null;
    protected long lastSendTime = 0L;

    public UserConnection(SocketManager manager) {
        if (manager != null) {
            this.connectID = manager.getConnectId();
        }
        this.lastSendTime = System.currentTimeMillis();
        this.cacheReceive = new PacketCache();
        this.cacheSend = new LinkedList<ByteBuffer>();
        this.sockManager = manager;
    }

    protected UserConnection() {
    }

    public boolean isReceive() {
        block5: {
            if (!this.isReceiveCache()) break block5;
            return true;
        }
        try {
            if (this.sockManager.isReceiveSocket()) {
                this.cacheReceivePacket();
                if (this.isReceiveCache()) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            log.error(e);
        }
        return false;
    }

    protected boolean cacheReceivePacket() throws IOException {
        if (this.isReceiveCache()) {
            return true;
        }
        if (this.sockManager.isReceiveSocket()) {
            this.sockManager.read(this.cacheReceive);
            if (this.isReceiveCache()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isReceiveCache() throws IOException {
        return this.cacheReceive.isGet();
    }

    public Packet receive() {
        ByteBuffer buff;
        block6: {
            block5: {
                try {
                    buff = null;
                    if (this.cacheReceivePacket()) break block5;
                    return null;
                }
                catch (Exception e) {
                    log.error(e);
                    return null;
                }
            }
            buff = this.cacheReceive.get();
            if (buff != null) break block6;
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace(new String(buff.array()));
        }
        Packet packet = PacketFactory.parsePacket(buff);
        return packet;
    }

    public void send(Packet packet) throws IOException, PacketFormatException {
        this.cacheSendPacket(packet);
        this.sendPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket() throws IOException {
        while (!this.cacheSend.isEmpty()) {
            ByteBuffer buff;
            List<ByteBuffer> list = this.cacheSend;
            synchronized (list) {
                buff = this.cacheSend.get(0);
            }
            if (log.isTraceEnabled()) {
                log.trace("send: length = " + buff.array().length);
                log.trace("send: data = \n" + new String(buff.array()));
            }
            this.sockManager.write(buff);
            list = this.cacheSend;
            synchronized (list) {
                this.cacheSend.remove(0);
            }
            this.lastSendTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheSendPacket(Packet packet) throws PacketFormatException {
        List<ByteBuffer> list = this.cacheSend;
        synchronized (list) {
            this.cacheSend.add(packet.toBytes());
        }
    }

    protected boolean islastSendNearly() {
        long now = System.currentTimeMillis();
        return now - this.lastSendTime <= 30000L;
    }

    public boolean isFailedSending() {
        if (this.islastSendNearly()) {
            return false;
        }
        try {
            this.send(PacketFactory.createNoopPacket());
            return false;
        }
        catch (Exception e) {
            log.error("noop error.", e);
            return true;
        }
    }

    protected int getTimeLimit() {
        return 30000;
    }

    public boolean isSendPacket() {
        return this.cacheSend.size() > 0;
    }

    public void close() {
        try {
            this.sockManager.close();
        }
        catch (Exception e) {
            log.error("error in close, ", e);
        }
    }

    public boolean isConnected() {
        return this.sockManager.isConnected();
    }
}

