/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.level;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import jp.sourceforge.mmosf.server.level.GeomapData;
import jp.sourceforge.mmosf.server.level.MobFactory;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelManager {
    protected GeomapData geo = null;
    private int id = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public GeomapData getZoneGeomap(int zoneID) {
        if (this.geo == null) {
            this.geo = new GeomapData();
        }
        return this.geo;
    }

    public List<Mob> getMob(int zoneId) {
        LinkedList<Mob> list = new LinkedList<Mob>();
        list.add(MobFactory.createQuestMobA(this.createPos(23, 8, zoneId), this.createId()));
        list.add(MobFactory.createQuestMobB(this.createPos(10, 8, zoneId), this.createId()));
        list.add(MobFactory.createMob(this.createPos(15, 8, zoneId), '\uff23', this.createId()));
        list.add(MobFactory.createMob(this.createPos(12, 23, zoneId), '\uff24', this.createId()));
        char c = '\uff25';
        while (c <= '\uff3a') {
            list.add(MobFactory.createMob(this.createPos(zoneId), c, this.createId()));
            c = (char)(c + '\u0001');
        }
        int i = 0;
        while (i < 20) {
            list.add(MobFactory.createTreeMob(this.createPos(zoneId), this.createId()));
            ++i;
        }
        list.add(MobFactory.createDoorMob(this.createPos(6, 15, zoneId), Vector.NORTH, this.createId()));
        list.add(MobFactory.createDoorMob(this.createPos(44, 3, zoneId), Vector.EAST, this.createId()));
        return list;
    }

    private Position createPos(int zoneId) {
        int y = this.rd.nextInt(this.getZoneGeomap(zoneId).getMapHeight() / 5);
        int x = this.rd.nextInt(this.getZoneGeomap(zoneId).getMapWidth() / 5);
        Position pos = new Position(x, y, 0.0);
        pos.zoneID = zoneId;
        return pos;
    }

    private Position createPos(int x, int y, int zoneId) {
        Position pos = new Position(x, y, 0.0);
        pos.zoneID = zoneId;
        return pos;
    }

    public int createId() {
        return this.id++;
    }
}

