/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.mmosf.server.object.Mob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCache {
    private static Log log = LogFactory.getLog(UpdateCache.class);
    protected Map<Integer, Mob> map = new HashMap<Integer, Mob>();

    protected Mob createMob(Mob mob) {
        return new Mob(mob);
    }

    public void pickUpdate(List<Mob> srcList, List<Mob> listUpdate, List<Mob> listDelete) {
        HashMap<Integer, Mob> newMap = new HashMap<Integer, Mob>();
        for (Mob mob : srcList) {
            log.isTraceEnabled();
            Integer mobId = mob.getId();
            Mob cache = this.map.get(mobId);
            if (cache == null) {
                log.trace("no cache.");
                listUpdate.add(mob);
            } else {
                if (!mob.equals(cache)) {
                    log.trace("update.");
                    listUpdate.add(mob);
                }
                this.map.remove(mobId);
            }
            newMap.put(mobId, this.createMob(mob));
        }
        if (!this.map.isEmpty()) {
            Set<Integer> keys = this.map.keySet();
            for (Integer id : keys) {
                listDelete.add(this.map.get(id));
            }
        }
        this.map.clear();
        this.map = newMap;
    }

    public List<Mob> update(List<Mob> listUpdate, List<Mob> listDelete) {
        if (listUpdate != null) {
            for (Mob mob : listUpdate) {
                Mob cache = this.map.get(mob.getId());
                if (cache != null && mob.equals(cache)) continue;
                this.map.put(mob.getId(), this.createMob(mob));
            }
        }
        if (listDelete != null) {
            for (Mob mob : listDelete) {
                this.map.remove(mob.getId());
            }
        }
        return this.getAll();
    }

    private List<Mob> getAll() {
        LinkedList<Mob> list = new LinkedList<Mob>();
        Set<Map.Entry<Integer, Mob>> set = this.map.entrySet();
        Iterator<Map.Entry<Integer, Mob>> it = set.iterator();
        while (it.hasNext()) {
            Mob mob = it.next().getValue();
            list.add(mob);
        }
        return list;
    }

    public Mob get(int id) {
        return this.map.get(id);
    }
}

