/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object;

public class Vector {
    public static final Vector ZERO = new Vector(0, 0, 0);
    public static final Vector NORTH = new Vector(0, -1, 0);
    public static final Vector SOUTH = new Vector(0, 1, 0);
    public static final Vector EAST = new Vector(1, 0, 0);
    public static final Vector WEST = new Vector(-1, 0, 0);
    public static final Vector NORTH_EAST = new Vector(0.7, -0.7, 0.0);
    public static final Vector NORTH_WEST = new Vector(-0.7, -0.7, 0.0);
    public static final Vector SOUTH_EAST = new Vector(0.7, 0.7, 0.0);
    public static final Vector SOUTH_WEST = new Vector(-0.7, 0.7, 0.0);
    private final double x;
    private final double y;
    private final double z;

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(Vector vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vector(Vector vec, double mutiply) {
        this.x = vec.x * mutiply;
        this.y = vec.y * mutiply;
        this.z = vec.z * mutiply;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector v = (Vector)obj;
        return this.getdX() == v.getdX() && this.getdY() == v.getdY() && this.getdZ() == v.getdZ();
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean isLessOne() {
        return -1.0 < this.x && this.x < 1.0 && -1.0 < this.y && this.y < 1.0 && -1.0 < this.z && this.z < 1.0;
    }

    public String toString() {
        return "x=" + this.x + ",y=" + this.y + ",z=" + this.z;
    }

    public String toString2() {
        return String.valueOf(this.x) + "," + this.y + "," + this.z;
    }

    public static Vector valueOf(String string) {
        if (string == null || string.length() == 0) {
            return ZERO;
        }
        String[] split = string.split(",");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        while (split != null && i < split.length) {
            String[] value;
            if (split[i] != null && split[i].length() != 0 && (value = split[i].split("=")) != null && value.length >= 2 && value[0] != null) {
                if (value[0].equalsIgnoreCase("x")) {
                    x = Double.valueOf(value[1]);
                } else if (value[0].equalsIgnoreCase("y")) {
                    y = Double.valueOf(value[1]);
                } else if (value[0].equalsIgnoreCase("z")) {
                    z = Double.valueOf(value[1]);
                }
            }
            ++i;
        }
        return new Vector(x, y, z);
    }

    public static Vector valueOf2(String string) {
        if (string == null || string.length() == 0) {
            return ZERO;
        }
        String[] split = string.split(",");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        while (split != null && i < split.length) {
            switch (i) {
                case 0: {
                    x = Double.valueOf(split[i]);
                    break;
                }
                case 1: {
                    y = Double.valueOf(split[i]);
                    break;
                }
                case 2: {
                    z = Double.valueOf(split[i]);
                }
            }
            ++i;
        }
        return new Vector(x, y, z);
    }

    public Vector getDirection() {
        if (this.x > 0.0 && this.y == 0.0) {
            return EAST;
        }
        if (this.x > 0.0 && this.y > 0.0) {
            return SOUTH_EAST;
        }
        if (this.x > 0.0 && this.y < 0.0) {
            return NORTH_EAST;
        }
        if (this.x < 0.0 && this.y == 0.0) {
            return WEST;
        }
        if (this.x < 0.0 && this.y > 0.0) {
            return SOUTH_WEST;
        }
        if (this.x < 0.0 && this.y < 0.0) {
            return NORTH_WEST;
        }
        if (this.x == 0.0 && this.y > 0.0) {
            return SOUTH;
        }
        if (this.x == 0.0 && this.y < 0.0) {
            return NORTH;
        }
        return ZERO;
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public int getZ() {
        return (int)this.z;
    }

    public double getdX() {
        return this.x;
    }

    public double getdY() {
        return this.y;
    }

    public double getdZ() {
        return this.z;
    }

    public Vector getBaseVector() {
        int x = 0;
        int y = 0;
        int z = 0;
        if (this.getdX() > 0.0) {
            x = 1;
        } else if (this.getdX() < 0.0) {
            x = -1;
        }
        if (this.getdY() > 0.0) {
            y = 1;
        } else if (this.getdY() < 0.0) {
            y = -1;
        }
        if (this.getdZ() > 0.0) {
            z = 1;
        } else if (this.getdZ() < 0.0) {
            z = -1;
        }
        return new Vector(x, y, z);
    }
}

