/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.object.test;

import jp.sourceforge.mmosf.server.Perception;
import jp.sourceforge.mmosf.server.object.MoveObject;
import jp.sourceforge.mmosf.server.object.MovingRnd;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.test.DebugMovingVector;
import org.junit.Assert;
import org.junit.Test;

public class TestMobMove
implements Perception {
    @Test
    public void TestDirection() {
        Assert.assertEquals((Object)Vector.EAST, (Object)Vector.EAST.getDirection());
        Assert.assertEquals((Object)Vector.WEST, (Object)Vector.WEST.getDirection());
        Assert.assertEquals((Object)Vector.SOUTH, (Object)Vector.SOUTH.getDirection());
        Assert.assertEquals((Object)Vector.NORTH, (Object)Vector.NORTH.getDirection());
        Assert.assertEquals((Object)Vector.NORTH_EAST, (Object)Vector.NORTH_EAST.getDirection());
        Assert.assertEquals((Object)Vector.NORTH_WEST, (Object)Vector.NORTH_WEST.getDirection());
        Assert.assertEquals((Object)Vector.SOUTH_EAST, (Object)Vector.SOUTH_EAST.getDirection());
        Assert.assertEquals((Object)Vector.SOUTH_WEST, (Object)Vector.SOUTH_WEST.getDirection());
    }

    @Test
    public void TestDirection2() {
        DebugMovingVector mv = new DebugMovingVector(new Position(0.0, 0.0, 0.0));
        Vector v = mv.getVectorPerFrame(new Vector(20, 20, 0));
        Assert.assertEquals((Object)v.getDirection(), (Object)Vector.SOUTH_EAST);
    }

    @Test
    public void TestPcMove() {
        DebugMovingVector pc = new DebugMovingVector(new Position(0.5, 0.5, 0.5));
        this.testMove(pc, Vector.NORTH);
        this.testMove(pc, Vector.SOUTH);
        this.testMove(pc, Vector.EAST);
        this.testMove(pc, Vector.WEST);
        this.testMove(pc, Vector.NORTH_EAST);
        this.testMove(pc, Vector.NORTH_WEST);
        this.testMove(pc, Vector.SOUTH_EAST);
        pc.setPosition(new Position(0.0, 0.0, 0.0));
        this.testMove(pc, Vector.SOUTH_WEST);
    }

    @Test
    public void TestPcMove3() {
        DebugMovingVector mv = new DebugMovingVector(new Position(0.5, 0.5, 0.5));
        this.testMoveContinual(mv, new Vector(1, 0, 0));
        mv.setPosition(new Position(0.5, 0.5, 0.5));
        this.testMoveContinual(mv, Vector.NORTH_EAST);
        this.testMoveContinual(mv, new Vector(1, 1, 0));
        this.testMoveContinual(mv, new Vector(3, 0, 0));
        Vector v = new Vector(0.3, 0.0, 0.0);
        this.testMoveContinual(mv, v);
    }

    @Test
    public void TestPcMove4() {
        DebugMovingVector pc = new DebugMovingVector(new Position(0.0, 0.0, 0.0));
        this.testMoveContinual(pc, new Vector(-1, 0, 0));
        this.testMoveContinual(pc, new Vector(-3, 0, 0));
        Vector v = new Vector(-0.3, 0.0, 0.0);
        this.testMoveContinual(pc, v);
    }

    private void testMove(DebugMovingVector mv, Vector v) {
        try {
            mv.setVector(v);
            double speed = mv.getSpeed();
            Position oldPos = mv.getPosition();
            mv.updateTime(0L);
            mv.updateTime(1000L);
            mv.move(this);
            Position newPos = mv.getPosition().getSubtracted(oldPos);
            Assert.assertEquals((long)((int)(v.getdX() * speed)), (long)newPos.getX());
            Assert.assertEquals((long)((int)(v.getdY() * speed)), (long)newPos.getY());
            Assert.assertEquals((long)((int)(v.getdZ() * speed)), (long)newPos.getZ());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    public boolean isCollision(MoveObject mo) {
        return true;
    }

    public boolean isEnableMove(MoveObject mo) {
        return true;
    }

    private void testMoveContinual(DebugMovingVector mv, Vector v) {
        class TestPerception
        implements Perception {
            Position pos1 = null;
            Position pos2;

            TestPerception() {
            }

            public boolean isCollision(MoveObject mo) {
                if (this.pos1 != null) {
                    int x = this.pos1.getX() - mo.getNowPos().getX();
                    int y = this.pos1.getY() - mo.getNowPos().getY();
                    int z = this.pos1.getZ() - mo.getNowPos().getZ();
                    if (x * x != 1 && y * y != 1 && z * z != 1) {
                        Assert.fail((String)"bad increment collision.");
                    }
                }
                this.pos1 = mo.getNowPos();
                return true;
            }

            public boolean isEnableMove(MoveObject mo) {
                if (this.pos2 != null) {
                    int x = this.pos2.getX() - mo.getNowPos().getX();
                    int y = this.pos2.getY() - mo.getNowPos().getY();
                    int z = this.pos2.getZ() - mo.getNowPos().getZ();
                    if (x * x != 1 && y * y != 1 && z * z != 1) {
                        Assert.fail((String)"bad increment enableMove.");
                    }
                }
                this.pos2 = mo.getNowPos();
                return true;
            }
        }
        TestPerception testP = new TestPerception();
        try {
            Position oldPos = mv.getPosition();
            mv.setVector(v);
            double speed = mv.getSpeed();
            int second = 5;
            mv.updateTime(0L);
            mv.updateTime(1000 * second);
            mv.move(testP);
            Position newPos = mv.getPosition().getSubtracted(oldPos);
            Assert.assertEquals((long)((int)(v.getdX() * speed * (double)second + 0.5)), (long)newPos.getX());
            Assert.assertEquals((long)((int)(v.getdY() * speed * (double)second + 0.5)), (long)newPos.getY());
            Assert.assertEquals((long)((int)(v.getdZ() * speed * (double)second + 0.5)), (long)newPos.getZ());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void TestCreateMoveObject() {
        DebugMovingVector mv = new DebugMovingVector(new Position(10.5, 10.5, 10.5));
        Position oldPos = mv.getPosition();
        mv.setVector(Vector.NORTH_EAST);
        mv.updateTime(0L);
        mv.updateTime(1000L);
        MoveObject mo = mv.createMoveObject();
        Assert.assertTrue((boolean)mo.getVec().equals(new Vector(Vector.NORTH_EAST, mv.getSpeed())));
        Position nextPos = oldPos.getMoved(mo.getVec());
        Assert.assertEquals((Object)mo.getNextPos(), (Object)nextPos);
    }

    @Test
    public void TestCreateMoveObject2() {
        DebugMovingVector mv = new DebugMovingVector(new Position(10.0, 10.0, 10.0));
        Position oldPos = mv.getPosition();
        Vector vector = new Vector(3, 3, 0);
        mv.setVector(vector);
        mv.updateTime(0L);
        mv.updateTime(1000L);
        MoveObject mo = mv.createMoveObject();
        Assert.assertTrue((boolean)mo.getVec().equals(new Vector(vector, mv.getSpeed())));
        Position nextPos = oldPos.getMoved(mo.getVec());
        Assert.assertEquals((Object)mo.getNextPos(), (Object)nextPos);
    }

    @Test
    public void TestMovingRndGetVector() {
        class DebugMovingRnd
        extends MovingRnd {
            public DebugMovingRnd(Position pos) {
                super(pos);
            }

            public void setNextPosition(Position next) {
                this.nextPos = next;
            }
        }
        DebugMovingRnd dmr = new DebugMovingRnd(new Position(10.0, 10.0, 0.0));
        dmr.setNextPosition(new Position(10.0, 10.0, 0.0));
        Vector vec = dmr.getVector();
        Assert.assertTrue((boolean)vec.isZero());
    }
}

