/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.packet;

import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;

public class MovePacket
extends Packet {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final String POS_X = "pos_x";
    public static final String POS_Y = "pos_y";
    public static final String POS_Z = "pos_z";
    public static final String NEXT_X = "next_x";
    public static final String NEXT_Y = "next_y";
    public static final String NEXT_Z = "next_z";
    public static final String DIRECTION_X = "drc_x";
    public static final String DIRECTION_Y = "drc_y";
    public static final String DIRECTION_Z = "drc_z";
    public static final String SPEED = "speed";
    public static final String MOTION = "motion";
    public static final String MOVING = "moving";

    public void setVector(Vector drc) {
        this.setDouble(X, drc.getdX());
        this.setDouble(Y, drc.getdY());
        this.setDouble(Z, drc.getdZ());
    }

    public Vector getVector() throws PacketFormatException {
        Vector drc = new Vector(this.getDouble(X), this.getDouble(Y), this.getDouble(Z));
        return drc;
    }

    public void setDirection(Vector drc) {
        this.setDouble(DIRECTION_X, drc.getdX());
        this.setDouble(DIRECTION_Y, drc.getdY());
        this.setDouble(DIRECTION_Z, drc.getdZ());
    }

    public Vector getDirection() throws PacketFormatException {
        Vector drc = new Vector(this.getDouble(DIRECTION_X), this.getDouble(DIRECTION_Y), this.getDouble(DIRECTION_Z));
        return drc;
    }

    public void setPosition(Position pos) {
        this.setInt(POS_X, pos.getX());
        this.setInt(POS_Y, pos.getY());
        this.setInt(POS_Z, pos.getZ());
    }

    public Position getPosition() throws PacketFormatException {
        int x = this.getInt(POS_X);
        int y = this.getInt(POS_Y);
        int z = this.getInt(POS_Z);
        Position pos = new Position(x, y, z);
        return pos;
    }
}

