/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.sample;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import jp.sourceforge.mmosf.server.ListeningServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class SampleGameServer {
    private static Log log = LogFactory.getLog(SampleGameServer.class);

    public static void main(String[] args) {
        try {
            LogFactory.getFactory().setAttribute("org.apache.commons.logging.log", "org.apache.commons.logging.impl.Log4JLogger");
            URL path = SampleGameServer.class.getClassLoader().getResource("jp/sourceforge/mmosf/server/conf/log4j.properties");
            PropertyConfigurator.configure(path);
            ListeningServer listeningServer = SampleGameServer.loadConf();
            if (listeningServer == null) {
                listeningServer = new ListeningServer(2000);
                log.info("listen 2000");
            }
            Thread th2 = new Thread(listeningServer);
            th2.run();
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    private static ListeningServer loadConf() {
        File file;
        block3: {
            try {
                file = new File("server.conf");
                if (file.exists()) break block3;
                return null;
            }
            catch (Exception e) {
                log.error("error in load conf, ", e);
                return null;
            }
        }
        BufferedReader r = new BufferedReader(new FileReader(file));
        String str = r.readLine();
        r.close();
        log.info("listen " + str);
        return new ListeningServer(Integer.valueOf(str));
    }
}

