/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.test;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mmosf.server.level.MobFactory;
import jp.sourceforge.mmosf.server.level.QuestFactory;
import jp.sourceforge.mmosf.server.object.Mob;
import jp.sourceforge.mmosf.server.object.MovingVector;
import jp.sourceforge.mmosf.server.object.Position;
import jp.sourceforge.mmosf.server.object.Vector;
import jp.sourceforge.mmosf.server.object.action.ActionElement;
import jp.sourceforge.mmosf.server.object.quest.Quest;
import jp.sourceforge.mmosf.server.packet.MenuPacket;
import jp.sourceforge.mmosf.server.packet.MovePacket;
import jp.sourceforge.mmosf.server.packet.Packet;
import jp.sourceforge.mmosf.server.packet.PacketFactory;
import jp.sourceforge.mmosf.server.packet.PacketFormatException;
import jp.sourceforge.mmosf.server.packet.UpdatePacket;
import org.junit.Assert;
import org.junit.Test;

public class TestPacketFactory {
    @Test
    public void testVisual() {
        try {
            Position pos = new Position(5.0, 5.0, 0.0);
            Mob mob = MobFactory.createTreeMob(pos, 5);
            LinkedList<Mob> list = new LinkedList<Mob>();
            LinkedList<Mob> list3 = new LinkedList<Mob>();
            list.add(mob);
            Packet pac = PacketFactory.createUpdatePacket(list, list3);
            LinkedList<Mob> list2 = new LinkedList<Mob>();
            LinkedList<Mob> list4 = new LinkedList<Mob>();
            PacketFactory.parseUpdatePacket((UpdatePacket)pac, list2, list4);
            Assert.assertTrue((((Mob)list2.get((int)0)).vis.getVtype() == mob.vis.getVtype() ? 1 : 0) != 0);
            Assert.assertTrue((((Mob)list2.get((int)0)).vis.getVtype() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((2 == mob.vis.getVtype() ? 1 : 0) != 0);
        }
        catch (PacketFormatException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCommand() {
        try {
            Position pos = new Position(5.0, 5.0, 0.0);
            Mob mob = MobFactory.createTreeMob(pos, 5);
            Packet pac = PacketFactory.createMenuResponsePaket("name", "text", mob.act.listAction);
            List<ActionElement> list2 = PacketFactory.parseMenuResponsePacket((MenuPacket)pac);
            Assert.assertEquals((Object)list2.get((int)0).name, (Object)mob.act.listAction.get((int)0).name);
            Assert.assertEquals((Object)list2.get((int)0).name, (Object)"\u5207\u308b");
            Assert.assertEquals((Object)"\u5207\u308b", (Object)mob.act.listAction.get((int)0).name);
        }
        catch (PacketFormatException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateQuestPacket() {
        try {
            Quest quest = QuestFactory.createSecondQuest();
            while (true) {
                Packet pac = PacketFactory.createQuestPacket(quest);
                Assert.assertNotNull((Object)pac);
                ByteBuffer buff = pac.toBytes();
                byte[] b = buff.array();
                Assert.assertNotNull((Object)b);
                Assert.assertTrue((b.length != 0 ? 1 : 0) != 0);
                if (!quest.isComplete()) {
                    quest.update();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMoveResponsePacket() {
        try {
            MovingVector mv = new MovingVector(new Position(1.0, 1.0, 1.0));
            mv.setVector(new Vector(2, 2, 2));
            mv.setDirection(new Vector(3, 3, 3));
            mv.setSpeed(4.0);
            MovePacket packet = (MovePacket)PacketFactory.createMoveResponsePacket(mv);
            MovingVector mv2 = MovingVector.valueOf2(packet.getString("moving"));
            Assert.assertTrue((String)"position", (boolean)mv2.getPosition().equals(new Position(1.0, 1.0, 1.0)));
            Assert.assertTrue((String)"vector", (boolean)mv2.getVector().equals(new Vector(2, 2, 2)));
            Assert.assertTrue((String)"direction", (boolean)mv2.getDirection().equals(new Vector(3, 3, 3)));
            Assert.assertEquals((String)"speed", (Object)mv2.getSpeed(), (Object)4.0);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testMobPacket() {
        try {
            Mob mob = new Mob(1, 2, Character.valueOf('a'), 3, 4);
            LinkedList<Mob> listUpdate = new LinkedList<Mob>();
            listUpdate.add(mob);
            Packet packet = PacketFactory.createUpdatePacket(listUpdate, new LinkedList<Mob>());
            LinkedList<Mob> listUpdate2 = new LinkedList<Mob>();
            PacketFactory.parseUpdatePacket((UpdatePacket)packet, listUpdate2, new LinkedList<Mob>());
            Mob mob2 = listUpdate2.get(0);
            Assert.assertEquals((Object)mob, (Object)mob2);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }
}

