using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Text.RegularExpressions;
using Microsoft.Win32;
using System.Diagnostics;

namespace FastBBSConfig
{
    public partial class BBSConfigDialog: Form
    {
        private BBSConfig bbsConfig;

        public BBSConfigDialog()
        {
            InitializeComponent();
            setValidator();

            bbsConfig =  new BBSConfig(Directory.GetCurrentDirectory(),
                getImagemagickDir());
            bbsConfigBindingSource.DataSource = bbsConfig;

            apachePathTextBox.Text = getApacheDir();

            FormBorderStyle = FormBorderStyle.FixedDialog;
        }

        private static string getApacheDir()
        {
            string keyName = "Software\\Apache Group\\Apache";
            string valueName = "ServerRoot";

            string dir = "";

            try {
                RegistryKey key = Registry.LocalMachine.OpenSubKey(keyName);
                dir = (string)(key.OpenSubKey(key.GetSubKeyNames()[0]).GetValue(valueName));
                key.Close();
            } catch (Exception) {
                // 
            }

            return dir;
        }

        private static string getImagemagickDir()
        {
            string keyName = "Software\\ImageMagick\\Current";
            string valueName = "LibPath";

            string dir = "";

            try {
                RegistryKey key = Registry.LocalMachine.OpenSubKey(keyName);
                dir = (string)key.GetValue(valueName);
                key.Close();
            } catch (Exception) {
                // 
            }

            return dir;
        }

        private void setValidator()
        {
            dataDirPathTextBox.Validating += 
                new CancelEventHandler((new FolderPathValidator(dataDirPathLabel, errorProvider)).validate);
            fileDirPathTextBox.Validating += 
                new CancelEventHandler((new FolderPathValidator(fileDirPathLabel, errorProvider)).validate);
            tempDirPathTextBox.Validating += 
                new CancelEventHandler((new FolderPathValidator(tempDirPathLabel, errorProvider)).validate);

            imageDirPathTextBox.Validating += 
                new CancelEventHandler((new FolderPathValidator(imageDirPathLabel, errorProvider)).validate);
            stylesheetDirPathTextBox.Validating += 
                new CancelEventHandler((new FolderPathValidator(stylesheetDirPathLabel, errorProvider)).validate);
            javascriptDirPathTextBox.Validating += 
                new CancelEventHandler((new FolderPathValidator(javascriptDirPathLabel, errorProvider)).validate);


            indexTmplPathTextBox.Validating +=
                new CancelEventHandler((new FilePathValidator(indexTmplPathLabel, errorProvider)).validate);
            commentTmplPathTextBox.Validating +=
                new CancelEventHandler((new FilePathValidator(commentTmplPathLabel, errorProvider)).validate);
            threadTmplPathTextBox.Validating +=
                new CancelEventHandler((new FilePathValidator(threadTmplPathLabel, errorProvider)).validate);
            postThreadTmplPathTextBox.Validating +=
                new CancelEventHandler((new FilePathValidator(postThreadTmplPathLabel, errorProvider)).validate);
        }

        private void modulePathButton_Click(object sender, EventArgs e)
        {
            string file_path = chooseModuleFile(modulePathLabel,
                modulePathTextBox.Text);

            if (file_path == null) {
                return;
            }

            bbsConfig.modulePath = file_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void apachePathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(apachePathLabel,
                apachePathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            apachePathTextBox.Text = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void imagemagickPathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(imagemagickPathLabel, 
                imagemagickPathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            bbsConfig.imagemagickPath = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void indexTmplPathButton_Click(object sender, EventArgs e)
        {
            string file_path = chooseTemplateFile(indexTmplPathLabel,
                indexTmplPathTextBox.Text);

            if (file_path == null) {
                return;
            }

            bbsConfig.indexTmplPath = file_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void commentTmplPathButton_Click(object sender, EventArgs e)
        {
            string file_path = chooseTemplateFile(commentTmplPathLabel,
                commentTmplPathTextBox.Text);

            if (file_path == null) {
                return;
            }

            bbsConfig.commentTmplPath = file_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void threadTmplPathButton_Click(object sender, EventArgs e)
        {
            string file_path = chooseTemplateFile(threadTmplPathLabel,
                threadTmplPathTextBox.Text);

            if (file_path == null) {
                return;
            }

            bbsConfig.threadTmplPath = file_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void postThreadTmplPathButton_Click(object sender, EventArgs e)
        {
            string file_path = chooseTemplateFile(postThreadTmplPathLabel,
                postThreadTmplPathTextBox.Text);

            if (file_path == null) {
                return;
            }

            bbsConfig.postThreadTmplPath = file_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void dataDirPathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(dataDirPathLabel, 
                dataDirPathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            bbsConfig.dataDirPath = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void fileDirPathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(fileDirPathLabel, 
                fileDirPathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            bbsConfig.fileDirPath = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void tempDirPathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(tempDirPathLabel, 
                tempDirPathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            bbsConfig.tempDirPath = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void imageDirPathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(imageDirPathLabel,
                imageDirPathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            bbsConfig.imageDirPath = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void stylesheetDirPathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(stylesheetDirPathLabel,
                stylesheetDirPathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            bbsConfig.stylesheetDirPath = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void javascriptDirPathButton_Click(object sender, EventArgs e)
        {
            string folder_path = chooseFolder(javascriptDirPathLabel, 
                javascriptDirPathTextBox.Text);

            if (folder_path == null) {
                return;
            }

            bbsConfig.javascriptDirPath = folder_path;
            bbsConfigBindingSource.ResetBindings(false);
            ValidateChildren();
        }

        private void copyButton_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(bbsConfig.apacheConfigText);
        }

        private void apacheStripButton_Click(object sender, EventArgs e)
        {
            ProcessStartInfo psi = new ProcessStartInfo();

            psi.FileName = apachePathTextBox.Text;
            psi.Verb = "explore";

            Process.Start(psi);
        }

        private void helpStripButton_Click(object sender, EventArgs e)
        {
            Process.Start("http://acapulco.dyndns.org/mod_fast_bbs/apache-win.htm");
        }

        private void copyToolStripButton_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(bbsConfig.apacheConfigText);
        }

        private string chooseModuleFile(Label label, string currentFile)
        {
            OpenFileDialog dialog = new OpenFileDialog();

            dialog.Title = label.Text + "IĂ";
            dialog.CheckFileExists = true;
            dialog.FileName = currentFile;
            dialog.Filter = "W[(mod_fast_bbs.so)|mod_fast_bbs.so";
            dialog.FilterIndex = 0;

            if (dialog.ShowDialog() != DialogResult.OK) {
                return null;
            }

            return dialog.FileName;
        }

        private string chooseFolder(Label label, string currentFolder)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();

            dialog.Description = label.Text + "IĂ";
            dialog.SelectedPath = currentFolder;

            if (dialog.ShowDialog() != DialogResult.OK) {
                return null;
            }

            return dialog.SelectedPath;
        }

        private string chooseTemplateFile(Label label, string currentFile)
        {
            OpenFileDialog dialog = new OpenFileDialog();

            dialog.Title = label.Text + "IĂ";
            dialog.CheckFileExists = true;
            dialog.FileName = currentFile;
            dialog.Filter = "ev[gt@C(*.htm)|*.htm";
            dialog.FilterIndex = 0;

            if (dialog.ShowDialog() != DialogResult.OK) {
                return null;
            }

            return dialog.FileName;
        }

        private void modulePathTextBox_Validating(object sender, CancelEventArgs e)
        {
            string path = (sender as TextBox).Text;

            if (!File.Exists(path)) {
                errorProvider.SetError(sender as TextBox,
                    "u" + modulePathLabel.Text + "v܂");
                return;
            }

            errorProvider.SetError(sender as TextBox, null);
        }

        private void apachePathTextBox_Validating(object sender, CancelEventArgs e)
        {
            string path = (sender as TextBox).Text;

            if (!File.Exists(Path.Combine(Path.Combine(path, "bin"), "Apache.exe"))) {
                errorProvider.SetError(sender as TextBox,
                    "u" + apachePathLabel.Text + "v܂");
                return;
            }

            errorProvider.SetError(sender as TextBox, null);
        }

        private void imagemagickPathTextBox_Validating(object sender, CancelEventArgs e)
        {
            string path = (sender as TextBox).Text;

            if (!File.Exists(Path.Combine(path, "CORE_RL_Magick++_.dll"))) {
                errorProvider.SetError(sender as TextBox,
                    "u" + imageDirPathLabel.Text + "v܂");
                return;
            }

            errorProvider.SetError(sender as TextBox, null);
        }

        private void baseUrlLabel_Validating(object sender, CancelEventArgs e)
        {
            string url = (sender as TextBox).Text;

            Regex regex = new System.Text.RegularExpressions.
                Regex("^(https?://(?:[\\w.-]+\\.)*(?:[\\w.-]+)(/(?:(?:[\\w.-])+/)*(?:(?:[\\w.-])+)))/?$");

            Match match = regex.Match(url);
            if (!match.Success) {
                errorProvider.SetError(sender as TextBox,
                    "u" + baseUrlLabel.Text + "v܂");
                return;
            }

            ((TextBox)sender).Text = match.Groups[1].ToString();
            bbsConfig.path = match.Groups[2].ToString();

            errorProvider.SetError(sender as TextBox, null);
        }

        class FolderPathValidator
        {
            private readonly Label label_;
            private readonly ErrorProvider errorProvider_;

            public FolderPathValidator(Label label, ErrorProvider errorProvider)
            {
                label_ = label;
                errorProvider_ = errorProvider;
            }

            public void validate(object sender, CancelEventArgs e)
            {
                string path = (sender as TextBox).Text;

                if (!Directory.Exists(path)) {
                    errorProvider_.SetError(sender as TextBox,
                        "u" + label_.Text + "vŎw肳ꂽtH_݂͑܂");
                    return;
                }

                errorProvider_.SetError(sender as TextBox, null);
            }
        }

        class FilePathValidator
        {
            private readonly Label label_;
            private readonly ErrorProvider errorProvider_;

            public FilePathValidator(Label label, ErrorProvider errorProvider)
            {
                label_ = label;
                errorProvider_ = errorProvider;
            }

            public void validate(object sender, CancelEventArgs e)
            {
                string path = (sender as TextBox).Text;

                if (!File.Exists(path)) {
                    errorProvider_.SetError(sender as TextBox,
                        "u" + label_.Text + "vŎw肳ꂽt@C݂͑܂");
                    return;
                }

                errorProvider_.SetError(sender as TextBox, null);
            }
        }

        private void BBSConfigDialog_Load(object sender, EventArgs e)
        {
            ValidateChildren();
        }

        private void textBox_KeyUp(object sender, KeyEventArgs e)
        {
            ValidateChildren();
        }

        private void configTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            ValidateChildren();
        }
    }
}
