/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BBSThreadWriter.cpp 1848 2006-10-21 14:14:40Z svn $
 *****************************************************************************/

#include "Environment.h"

#include "BBSThreadWriter.h"
#include "BBSThread.h"
#include "TemporaryPool.h"
#include "TemporaryFile.h"
#include "Message.h"
#include "Macro.h"
#include "SourceInfo.h"

SOURCE_INFO_ADD("$Id: BBSThreadWriter.cpp 1848 2006-10-21 14:14:40Z svn $");

/******************************************************************************
 * public メソッド
 *****************************************************************************/
BBSThreadWriter::BBSThreadWriter(apr_pool_t *pool, const char *dir_path)
  : BBSThreadIO(pool, dir_path)
{

}

void BBSThreadWriter::write(BBSThread *bbs_thread)
{
    const char *bthread_file_path;
    apr_mmap_t *bthread_file_map;
    TemporaryPool temp_pool(pool_);

    prepare_subdir(temp_pool.get(), bbs_thread->get_id());

    bthread_file_path = get_file_path(temp_pool.get(),
                                      bbs_thread->get_id());

    TemporaryFile bthread_file(temp_pool.get(), bthread_file_path);

    bthread_file.open(APR_WRITE);
    bthread_file.expand(bbs_thread->get_valid_size());
    bthread_file_map = bthread_file.mmap(0, bbs_thread->get_valid_size(),
                                         APR_MMAP_READ|APR_MMAP_WRITE);

    memcpy(bthread_file_map->mm, bbs_thread, bbs_thread->get_valid_size());

    bthread_file.commit();

    bbs_thread->reset_unsynced_comment_count();
}


// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
