/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: PostFlowController.h 1981 2006-11-12 06:40:26Z svn $
 *****************************************************************************/

#ifndef POST_FLOW_CONTROLLER_H
#define POST_FLOW_CONTROLLER_H

#include "Environment.h"

#include <cstdlib>

#include "apr_shm.h"
#include "apr_time.h"
#include "AtomicWrapper.h"

#include "Macro.h"
#include "Uncopyable.h"

using namespace std;

/**
 * @brief 書き込みのフロー制御を行うクラス．
 */
class PostFlowController: public Uncopyable
{
public:
    PostFlowController(apr_size_t min_post_interval_sec);
    bool can_post(const char *ip_address);
    void regist_post(const char *ip_address);
    static PostFlowController *get_instance(apr_shm_t *shm,
                                            apr_size_t min_post_interval_sec);
    static apr_size_t get_memory_size();

    static void dump_list(PostFlowController *flow_controller);

private:
    static const apr_size_t MAX_ADDRESS_LENGTH          = 40;
    static const apr_size_t BUSY;
    static const apr_size_t FREE;

    typedef struct Poster {
        char ip_address[MAX_ADDRESS_LENGTH+1]; // パスカル文字列
        apr_time_t time;
    } poster_t;

    void poster_list_add(const char *ip_address, char ip_address_length);
    void poster_list_clean();
    apr_time_t poster_list_is_contain(const char *ip_address,
                                      char ip_address_length) const;

    static void dump_poster(poster_t *poster);

    apr_atomic_t lock_;
    apr_time_t min_post_interval_time_;
    apr_size_t poster_top_;
    apr_size_t poster_tail_;
    poster_t poster_list_[PST_FLOW_CONTROL_BUFFER_SIZE];
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
