/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BBSCommentVariableCreator.h 2327 2006-12-29 18:07:16Z svn $
 *****************************************************************************/

#ifndef BBS_COMMENT_VARIABLE_CREATOR_H
#define BBS_COMMENT_VARIABLE_CREATOR_H

#include "Environment.h"

#include "apr_shm.h"

#include "BBSThread.h"
#include "TemplateVariable.h"
#include "TemplateVariableCreator.h"
#include "Uncopyable.h"

using namespace std;

class BBSCommentIterator;

/**
 * @brief テンプレートの変数を生成するクラス
 */
class BBSCommentVariableCreator: public Uncopyable
{
public:
    BBSCommentVariableCreator(const char **keys);
    TemplateVariable::variable_t *create(apr_pool_t *pool,
                                         BBSCommentIterator *comment_iter) const;
    TemplateVariable::variable_t *create(apr_pool_t *pool,
                                         BBSThread::bbs_comment_p_t *bcomment_p,
                                         void *var_memory,
                                         void *sca_memory) const;
    TemplateVariable::variable_t *create_navi(apr_pool_t *pool,
                                              BBSCommentIterator *comment_iter) const;
    static BBSCommentVariableCreator *get_instance(void *memory,
                                                   const char **keys);

private:
    typedef TemplateVariable::variable_t            variable_t;
    typedef TemplateVariable::scalar_t              scalar_t;
    typedef TemplateVariableCreator::key_index_t    key_index_t;

    typedef struct CommentKeyIndex {
        key_index_t no;
        key_index_t name;
        key_index_t date;
        key_index_t trip;
        key_index_t email;
        key_index_t message;
        key_index_t is_age;
        key_index_t image_ext;
        key_index_t thumb_width;
        key_index_t thumb_height;

        CommentKeyIndex()
          : no("no"),
            name("name"),
            date("date"),
            trip("trip"),
            email("email"),
            message("message"),
            is_age("is_age"),
            image_ext("image_ext"),
            thumb_width("thumb_width"),
            thumb_height("thumb_height")
        {

        }
    } comment_key_index_t;

    void init();
    apr_size_t get_comment_array_memory_size(BBSCommentIterator *comment_iter) const;
    apr_size_t get_comment_memory_size() const;

    const char **keys_;
    comment_key_index_t comment_key_index_;
    apr_size_t comment_key_index_max_;
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
