/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BBSThreadListReader.h 2050 2006-11-24 04:08:11Z svn $
 *****************************************************************************/

#ifndef BBS_THREAD_LIST_READER_H
#define BBS_THREAD_LIST_READER_H

#include "Environment.h"

#include <cstdlib>

#include "apr_pools.h"
#include "apr_shm.h"

#include "Uncopyable.h"

using namespace std;

class BBSThreadList;
class BBSThreadReader;

/**
 * @brief 掲示板のスレッドのリストを読み出すクラス．
 */
class BBSThreadListReader: public Uncopyable
{
public:
    /**
     * スレッドのリストを読み出します．
     *
     * @param[in] pool プール
     * @param[in] dir_path スレッドが保存されているディレクトリ
     * @param[in] shm 共有メモリ
     * @return 掲示板のスレッドのリスト
     */
    static BBSThreadList *read(apr_pool_t *pool, const char *dir_path,
                               apr_shm_t *shm);

private:
    BBSThreadListReader();

    static void get_subdir_threads(apr_pool_t *pool, const char *sub_dir_path,
                                   BBSThreadReader *thread_reader,
                                   BBSThreadList *thread_list);
    static bool is_subdir_name_valid(const char *subdir_name);
    static bool is_file_name_valid(const char *file_name);
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
