/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: Path.h 2015 2006-11-20 15:31:51Z svn $
 *****************************************************************************/

#ifndef PATH_H
#define PATH_H

#include "Environment.h"

#include <cstdlib>
#ifdef DEBUG
#include <iostream>
#endif

#include "apr_pools.h"

#include "Message.h"

using namespace std;

/**
 * @brief パスを表すクラス．
 */
class Path
{
public:
    static bool is_exist(apr_pool_t *pool, const char *path);
    static bool is_writable(apr_pool_t *pool, const char *path);
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
