/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: PostDataChecker.h 2319 2006-12-28 16:24:03Z svn $
 *****************************************************************************/

#ifndef POST_DATA_CHECKER_H
#define POST_DATA_CHECKER_H

#include "Environment.h"

#include "apr.h"

#include <cstdlib>

#include "BBSThread.h"
#include "Uncopyable.h"

using namespace std;

/**
 * @brief 書き込みデータのチェックを行うクラス．
 */
class PostDataChecker: public Uncopyable
{
public:
    static void validate_thread(const char *subject);
    static void validate_comment(const char *name, const char *trip,
                                 const char *email, const char *message,
                                 BBSThread::image_t *image, bool is_age,
                                 BBSThread::bbs_comment_flag_t *flag);
    static bool is_contain_url_link(const char *str);
    static bool is_contain_comment_link(const char *str);
    static bool is_contain_html(const char *str);
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
