/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: FileWriter.cpp 1696 2006-10-01 15:44:16Z svn $
 *****************************************************************************/

#include "Environment.h"

#include "FileWriter.h"
#include "File.h"
#include "SourceInfo.h"

SOURCE_INFO_ADD("$Id: FileWriter.cpp 1696 2006-10-01 15:44:16Z svn $");

/******************************************************************************
 * public メソッド
 *****************************************************************************/
FileWriter::FileWriter(apr_pool_t *pool, apr_file_t *file)
    : pool_(pool),
      file_(new File(pool, file)),
      write_size_(0)
{

}

void FileWriter::close()
{
    file_->close();
}

FileWriter::~FileWriter()
{
    try {
        close();
    } catch(const char *) {
        // 無視
    }

    delete file_;
}

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
