#include "mof/InputEventCondition.hpp"

mof::InputEventCondition::InputEventCondition(
	mof::InputReceiver::Key key, 
	const std::shared_ptr<mof::InputReceiver> &pInputReceiver)
	: m_key(key) , m_pInputReceiver(pInputReceiver)
{
	update();
}

mof::InputEventCondition::~InputEventCondition(){
}

bool mof::InputEventCondition::test(){
	return m_state;
}

void mof::InputEventCondition::update(){
	m_state = m_pInputReceiver->testKeyState(m_key);
}

bool mof::InputEventCondition::isDisposable(){
	return false;
}
