#ifndef MOF_MESH_BUILDER_HPP
#define MOF_MESH_BUILDER_HPP
#include <boost/scoped_ptr.hpp>
#include <boost/utility.hpp>
#include <memory>
#include <mof/tstring.hpp>
#include <mof/Graphics3D.hpp>


namespace mof{
	class Component3D;
	
	class MeshBuilder : boost::noncopyable
	{
		struct Impl;
		boost::scoped_ptr<Impl> m_pImpl;
	public:
		typedef std::shared_ptr<MeshBuilder> ptr;
		MeshBuilder( const mof::tstring& path );
		~MeshBuilder();

		mof::Graphics3D* construct() const;
	};
}

#endif
