#pragma once

#include "mof/PixelMap.hpp"
#include <memory>
#include <boost/noncopyable.hpp>
#include "mof/GraphicsDevice.hpp"

namespace mof{
    
	class Texture : boost::noncopyable
	{
	    friend void GraphicsDevice::setTexture( const Texture* );
		struct Impl;
		std::unique_ptr<Impl> m_pImpl;
		
	public:
		typedef std::shared_ptr<Texture> ptr;
		Texture( const tstring& filename );
		Texture( const std::shared_ptr<mof::PixelMap>& pPixelMap);
		~Texture();
		
		std::shared_ptr<mof::PixelMap> getPixelMap();

		int getWidth();
		int getHeight();
	
	};
}
