 #pragma once 
#include <mof/real.hpp>
#include <iostream>

 namespace mof{
 	struct Vector3D
 	{
 		real x , y , z;
 		Vector3D(real _x , real _y , real _z);
 		Vector3D();
 		~Vector3D(void);
 		void normalize();
 
 		mof::Vector3D operator +(const mof::Vector3D& rhs) const ;
 		mof::Vector3D operator -(const mof::Vector3D& rhs) const ;
 		mof::Vector3D operator *(real rhs) const;
 		mof::Vector3D operator /(real rhs) const;
 
 		//friend mof::Vector3D operator *(const mof::Vector3D& vec , real f);
 		friend mof::Vector3D operator *(real f ,  const mof::Vector3D & vec);
 
 
 		bool operator ==(const mof::Vector3D& rhs) const;
 		bool operator !=(const mof::Vector3D& rhs) const;

	    friend std::ostream& operator <<(std::ostream& os , const Vector3D& obj );
 	};
 
 	Vector3D operator *(real f ,  const mof::Vector3D & vec);
 } //namespace mof
 
