#pragma once
#include <memory>
#include <vector>
#include <list>
#include <map>
#include <mof/tstring.hpp>
#include <mof/Board.hpp>
#include <mof/VertexBuffer.hpp>
#include <mof/MeshBuilder.hpp>
#include <mof/Graphics3D.hpp>
#include <mof/particlegen.hpp>
#include <mof/stream/ReferenceWrapper.hpp>

namespace mof
{
	class Sprite;
	class particlegen;
	class Graphics3D;
	class Camera;
	class Light;
	class StaticSoundBuffer;
	class StreamSoundBuffer;

namespace widget
{
	class Pager;
	class Menu;
	class Frame;
}
	class SoundBuffer;

namespace script
{
//{{{ MessageData
		struct MessageData
		{
			std::shared_ptr<mof::widget::Pager> message_;
			std::shared_ptr<mof::widget::Frame> frame_;// Drawer
		};
//}}}	
//{{{ MenuData
		struct MenuData
		{
			std::shared_ptr<mof::widget::Menu> menu_;
			std::shared_ptr<mof::widget::Frame> frame_;// Drawer

		};
//}}}
//{{{ PictureData
		struct PictureData
		{
			std::shared_ptr<mof::Sprite> sprite_;
			ReferenceWrapper<Rectangle<float>> texcoord_ref_;
			typedef std::shared_ptr<PictureData> ptr;
		};
//}}}	
//{{{ vertex_buffer_obj
		struct vertex_buffer_obj
		{
			std::shared_ptr<mof::VertexBuffer<VertexXYZRHWCUV>> buffer_;
			mof::Texture::ptr texture_;
			typedef std::shared_ptr<vertex_buffer_obj> ptr;
		};
//}}}
//{{{ BoardData
		struct BoardData
		{
			std::shared_ptr<mof::Board> board_;
			typedef std::shared_ptr<BoardData> ptr;
		};
//}}}
//{{{ ParticlegenData	
		struct ParticlegenData
		{
			mof::particlegen::ptr particlegen_;
			ReferenceWrapper<Matrix3D> position_ref_;
			typedef std::shared_ptr<ParticlegenData> ptr;
		};
//}}}
//{{{ SolidData
		struct SolidData
		{
			mof::Graphics3D::ptr solid_;
			ReferenceWrapper<Matrix3D> position_ref_;
			ReferenceWrapper<Matrix3D> size_ref_;
			std::shared_ptr<mof::Light> light_;
			typedef std::shared_ptr<SolidData> ptr;
		};
//}}}	
//{{{ CameraData
		struct CameraData
		{
			std::shared_ptr<Camera> camera_;
			typedef std::shared_ptr<CameraData> ptr;
		};
//}}}
//{{{ light_obj
		struct light_obj
		{
			std::shared_ptr<Light> light_;
			mof::tstring type_;

			typedef std::shared_ptr<light_obj> ptr;
		};
//}}}
//{{{ StaticSoundData
		struct StaticSoundData
		{
			std::shared_ptr<mof::StaticSoundBuffer> sound_;
		};
//}}}
//{{{ SoundSourceData
		struct SoundSourceData
		{
			std::shared_ptr<mof::StaticSoundBuffer> source_;
			// TODO tween
		};
//}}}
//{{{ GameData
		struct GameData // TODO rename
		{
			std::vector<std::map<mof::tstring, mof::tstring>> data_;
			typedef std::shared_ptr<GameData> ptr;
			typedef std::map<mof::tstring, mof::tstring> entry_t;
			typedef std::pair<mof::tstring, mof::tstring> pair_t;

			friend std::ostream& operator <<(std::ostream& os , const GameData& obj);
		};
//}}}
}// namespace script
}// namespace mof
