#pragma once
#include <dsound.h>
#include <memory>
#include "mof/sound/SoundFile.hpp"
#include <mof/sound/component_sound.hpp>

namespace mof{
namespace sound
{
	class DirectSoundDevice;
}
	class SoundBuffer : public mof::sound::component_sound
	{
		LPDIRECTSOUNDBUFFER8 m_pBuffer;
		SoundFile* m_pResource;
		DWORD default_frequency_;
	protected:
		std::shared_ptr<sound::DirectSoundDevice> pDevice_;
		LPDIRECTSOUNDBUFFER8 getSoundBuffer(){return m_pBuffer;}
		SoundFile* getResource(){return m_pResource;}
	public:
		SoundBuffer(std::shared_ptr<sound::DirectSoundDevice> pDevice, LPDIRECTSOUNDBUFFER8 pBuffer , SoundFile* pResouce);
		virtual ~SoundBuffer();

		virtual bool initialize() = 0;
		virtual bool play(bool looping) = 0;
		virtual void stop() = 0;
		virtual bool is_playing() const;
		virtual void update();
	};

};
