 #pragma once
 
 #include <mof/Animation.hpp>
 
 namespace mof{
 
 
 
 template<typename T>
 class ParametricAnimation : public mof::Animation<T>{
 	const boost::shared_ptr<T>& m_parameter;
 public:
 
 	ParametricAnimation(const boost::shared_ptr<T>& parameter) 
 		: m_parameter(parameter){
 	}
 
 	virtual T getValue(mof::FrameNumber ) const{
 		return *m_parameter;
 	}
 
 };
 
 template<class T>
 typename mof::Animation<T>::Handler makeParametricHandler(const boost::shared_ptr<T>& parameter){
 	return mof::Animation<T>::Handler(new mof::ParametricAnimation<T>(parameter));
 }
 
 } //namespace mof
 
