 #pragma once
 #include <map>
 #include <stdexcept>
 #include <boost/function/function2.hpp>
 #include "mof/stream/KeyFrameAnimation.hpp"
 #include "mof/Matrix3D.hpp"
#include <memory>
 
 
 namespace mof{
 
 
 class Scaling3D : public mof::Manipulator<mof::Matrix3D>{
	 mof::Manipulator<mof::Vector3D>::ptr m_pBody;
 public:
	typedef std::pair<mof::frame_t, mof::Vector3D> keyframe_t;
 
 	Scaling3D(
 		const std::pair<mof::FrameNumber , mof::Vector3D>& front , 
 		const std::pair<mof::FrameNumber , mof::Vector3D>& back  
 		)
 	{
 		m_pBody = mof::makeKeyFrameAnimationHandler<mof::Vector3D >
			(
 				front, back, &mof::linerInterpolate<mof::Vector3D>
 			);
 	}
	
	Scaling3D
    (
 	    const mof::Manipulator<mof::Vector3D>::Handler&  body
 	)
    : m_pBody( body )
 	{
 	}

 
 	virtual mof::Matrix3D value( mof::FrameNumber frame) const{
 		return mof::Matrix3D::createScaling(m_pBody->value(frame));
 	}
 
	/*
 	mof::FrameNumber getFinalKeyFrameNumber(){
 		return m_pBody->getFinalKeyFrameNumber();
 	}
	*/
 
 
 };
 
 } //namespace mof
 
